/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.File;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.Embedded;
import org.apache.tapestry5.test.ServletContainerRunner;
import org.apache.tapestry5.test.TapestryRunnerConstants;

public class Tomcat6Runner
implements ServletContainerRunner {
    private final String description;
    private final int port;
    private final int sslPort;
    private Embedded tomcatServer;

    public Tomcat6Runner(String webappFolder, String contextPath, int port, int sslPort) throws Exception {
        this.port = port;
        this.sslPort = sslPort;
        String expandedPath = this.expand(webappFolder);
        this.description = String.format("<Tomcat6Runner:%s:%s/%s (%s)", contextPath, port, sslPort, expandedPath);
        this.tomcatServer = new Embedded();
        String tmpDir = System.getProperty("java.io.tmpdir");
        String fileSeparator = System.getProperty("file.separator");
        if (!tmpDir.endsWith(fileSeparator)) {
            tmpDir = tmpDir + fileSeparator;
        }
        this.tomcatServer.setCatalinaHome(tmpDir + "tomcat");
        Engine engine = this.tomcatServer.createEngine();
        engine.setDefaultHost("localhost");
        Host host = this.tomcatServer.createHost("localhost", expandedPath);
        engine.addChild((Container)host);
        Context context = this.tomcatServer.createContext(contextPath, expandedPath);
        Wrapper wrapper = context.createWrapper();
        String name = "DefaultServlet";
        wrapper.setName("DefaultServlet");
        wrapper.setServletClass(DefaultServlet.class.getName());
        context.addChild((Container)wrapper);
        context.addServletMapping("/", "DefaultServlet");
        File contextConfigFile = new File(webappFolder, "META-INF/context.xml");
        if (contextConfigFile.exists()) {
            context.setConfigFile(contextConfigFile.getAbsolutePath());
        }
        context.setLoader((Loader)new WebappLoader(this.getClass().getClassLoader()));
        host.addChild((Container)context);
        this.tomcatServer.addEngine(engine);
        Connector http = this.tomcatServer.createConnector("localhost", port, false);
        http.setAllowTrace(true);
        this.tomcatServer.addConnector(http);
        File keystoreFile = new File(TapestryRunnerConstants.MODULE_BASE_DIR, "src/test/conf/keystore");
        if (keystoreFile.exists()) {
            Connector https = this.tomcatServer.createConnector("localhost", sslPort, true);
            https.setProperty("keystore", keystoreFile.getPath());
            https.setProperty("keypass", "tapestry");
            this.tomcatServer.addConnector(https);
        }
        this.tomcatServer.start();
    }

    @Override
    public void stop() {
        System.out.printf("Stopping Tomcat instance on port %d/%d\n", this.port, this.sslPort);
        try {
            this.tomcatServer.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stopping Tomcat6 instance: " + ex.toString(), ex);
        }
        System.out.println("Tomcat instance has stopped.");
    }

    public String toString() {
        return this.description;
    }

    protected String expand(String moduleLocalPath) {
        File path = new File(moduleLocalPath);
        if (path.isAbsolute() && path.isDirectory()) {
            return moduleLocalPath;
        }
        return new File(TapestryRunnerConstants.MODULE_BASE_DIR, moduleLocalPath).getPath();
    }
}

