/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

class JSONTokener {
    private int index;
    private final String source;

    public JSONTokener(String source) {
        assert (source != null);
        this.index = 0;
        this.source = source;
    }

    public void back() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public boolean more() {
        return this.index < this.source.length();
    }

    public char next() {
        if (this.more()) {
            return this.source.charAt(this.index++);
        }
        return '\u0000';
    }

    public String next(int n) {
        int i = this.index;
        int j = i + n;
        if (j >= this.source.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.index += n;
        return this.source.substring(i, j);
    }

    public char nextClean() {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment");
                            }
                            if (c != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                    default: {
                        this.back();
                        return '/';
                    }
                }
            }
            if (c == '#') {
                while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                }
                continue;
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String nextString(char quote) {
        StringBuilder builder = new StringBuilder();
        block13: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            builder.append('\b');
                            continue block13;
                        }
                        case 't': {
                            builder.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            builder.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            builder.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            builder.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            builder.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            builder.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    builder.append(c);
                    continue block13;
                }
            }
            if (c == quote) {
                return builder.toString();
            }
            builder.append(c);
        }
    }

    public Object nextValue() {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer sb = new StringBuffer();
        char b = c;
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        this.back();
        String s = sb.toString().trim();
        if (s.equals("")) {
            throw this.syntaxError("Missing value");
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("null")) {
            return JSONObject.NULL;
        }
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0') {
                if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                    try {
                        return Integer.parseInt(s.substring(2), 16);
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return Integer.parseInt(s, 8);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                return Integer.valueOf(s);
            }
            catch (Exception e) {
                try {
                    return Long.valueOf(s);
                }
                catch (Exception f) {
                    try {
                        return Double.valueOf(s);
                    }
                    catch (Exception g) {
                        return s;
                    }
                }
            }
        }
        return s;
    }

    RuntimeException syntaxError(String message) {
        return new RuntimeException(message + this.toString());
    }

    public String toString() {
        return " at character " + this.index + " of " + this.source;
    }
}

