/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;

public class PropertyShadowBuilderImpl
implements PropertyShadowBuilder {
    private final PropertyAccess propertyAccess;
    private final PlasticProxyFactory proxyFactory;

    public PropertyShadowBuilderImpl(@Builtin PlasticProxyFactory proxyFactory, PropertyAccess propertyAccess) {
        this.proxyFactory = proxyFactory;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public <T> T build(final Object source, final String propertyName, final Class<T> propertyType) {
        final Class<?> sourceClass = source.getClass();
        final PropertyAdapter adapter = this.propertyAccess.getAdapter(sourceClass).getPropertyAdapter(propertyName);
        if (adapter == null) {
            throw new RuntimeException(ServiceMessages.noSuchProperty(sourceClass, (String)propertyName));
        }
        if (!adapter.isRead()) {
            throw new RuntimeException(String.format("Class %s does not provide an accessor ('getter') method for property '%s'.", source.getClass().getName(), propertyName));
        }
        if (!propertyType.isAssignableFrom(adapter.getType())) {
            throw new RuntimeException(ServiceMessages.propertyTypeMismatch((String)propertyName, sourceClass, (Class)adapter.getType(), propertyType));
        }
        ClassInstantiator instantiator = this.proxyFactory.createProxy(propertyType, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                final PlasticField sourceField = plasticClass.introduceField(sourceClass, "source").inject(source);
                PlasticMethod delegateMethod = plasticClass.introducePrivateMethod(propertyType.getName(), "readProperty", null, null);
                delegateMethod.changeImplementation(new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().getField(sourceField);
                        builder.invoke(sourceClass, propertyType, adapter.getReadMethod().getName(), new Class[0]);
                        builder.dupe().when(Condition.NULL, new InstructionBuilderCallback(){

                            public void doBuild(InstructionBuilder builder) {
                                builder.throwException(NullPointerException.class, String.format("Unable to delegate method invocation to property '%s' of %s, because the property is null.", propertyName, source));
                            }
                        });
                        builder.returnResult();
                    }
                });
                for (Method m : propertyType.getMethods()) {
                    plasticClass.introduceMethod(m).delegateTo(delegateMethod);
                }
                plasticClass.addToString(String.format("<Shadow: property %s of %s>", propertyName, source));
            }
        });
        return propertyType.cast(instantiator.newInstance());
    }
}

