/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.exceptions;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Reducer;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ExceptionAnalysis;
import org.apache.tapestry5.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry5.ioc.services.ExceptionInfo;
import org.apache.tapestry5.services.ExceptionReportWriter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Session;

public class ExceptionReportWriterImpl
implements ExceptionReportWriter {
    private static final Reducer<Integer, Integer> MAX = new Reducer<Integer, Integer>(){

        public Integer reduce(Integer accumulator, Integer element) {
            return Math.max(accumulator, element);
        }
    };
    private static final Mapper<String, Integer> STRING_TO_LENGTH = new Mapper<String, Integer>(){

        public Integer map(String element) {
            return element.length();
        }
    };
    private static final Mapper<ExceptionInfo, Flow<String>> EXCEPTION_INFO_TO_PROPERTY_NAMES = new Mapper<ExceptionInfo, Flow<String>>(){

        public Flow<String> map(ExceptionInfo element) {
            return F.flow((Collection)element.getPropertyNames());
        }
    };
    @Inject
    private ExceptionAnalyzer analyzer;
    @Inject
    private RequestGlobals requestGlobals;
    @Inject
    @Symbol(value="tapestry.context-path")
    private String contextPath;

    @Override
    public void writeReport(PrintWriter writer, Throwable exception) {
        this.writeReport(writer, this.analyzer.analyze(exception));
    }

    private PropertyWriter newPropertyWriter(final PrintWriter writer, Iterable<String> names) {
        final int maxPropertyNameLength = (Integer)F.flow(names).map(STRING_TO_LENGTH).reduce(MAX, (Object)0);
        final String propertyNameFormat = "  %" + maxPropertyNameLength + "s: %s%n";
        return new PropertyWriter(){

            @Override
            public void write(String name, Object value) {
                if (value.getClass().isArray()) {
                    this.write(name, this.toList(value));
                    return;
                }
                if (value instanceof Iterable) {
                    boolean first = true;
                    Iterable iterable = (Iterable)value;
                    Iterator i = iterable.iterator();
                    while (i.hasNext()) {
                        if (first) {
                            writer.printf(propertyNameFormat, name, i.next());
                            first = false;
                            continue;
                        }
                        for (int j = 0; j < maxPropertyNameLength + 4; ++j) {
                            writer.write(32);
                        }
                        writer.println(i.next());
                    }
                    return;
                }
                writer.printf(propertyNameFormat, name, value);
            }

            private List toList(Object array) {
                int count = Array.getLength(array);
                ArrayList<Object> result = new ArrayList<Object>(count);
                for (int i = 0; i < count; ++i) {
                    result.add(Array.get(array, i));
                }
                return result;
            }
        };
    }

    @Override
    public void writeReport(PrintWriter writer, ExceptionAnalysis analysis) {
        writer.printf("EXCEPTION STACK:%n%n", new Object[0]);
        Flow propertyNames = F.flow((Collection)analysis.getExceptionInfos()).mapcat(EXCEPTION_INFO_TO_PROPERTY_NAMES).append((Object[])new String[]{"Exception", "Message"});
        PropertyWriter pw = this.newPropertyWriter(writer, (Iterable<String>)propertyNames);
        boolean first = true;
        for (ExceptionInfo info : analysis.getExceptionInfos()) {
            if (first) {
                writer.println();
                first = false;
            }
            pw.write("Exception", info.getClassName());
            pw.write("Message", info.getMessage());
            for (String name : info.getPropertyNames()) {
                pw.write(name, info.getProperty(name));
            }
            if (!info.getStackTrace().isEmpty()) {
                writer.printf("%n  Stack trace:%n%n", new Object[0]);
                for (StackTraceElement e : info.getStackTrace()) {
                    writer.printf("  - %s%n", e.toString());
                }
            }
            writer.println();
        }
        Request request = this.requestGlobals.getRequest();
        if (request != null) {
            Session session;
            pw = this.newPropertyWriter(writer, (Iterable<String>)((Flow)F.flow(request.getParameterNames()).concat(request.getHeaderNames())).append((Object[])new String[]{"serverName", "removeHost"}));
            writer.printf("REQUEST:%n%nBasic Information:%n%n", new Object[0]);
            List flags = CollectionFactory.newList();
            if (request.isXHR()) {
                flags.add("XHR");
            }
            if (request.isRequestedSessionIdValid()) {
                flags.add("requestedSessionIdValid");
            }
            if (request.isSecure()) {
                flags.add("secure");
            }
            pw.write("contextPath", this.contextPath);
            if (!flags.isEmpty()) {
                pw.write("flags", InternalUtils.joinSorted((Collection)flags));
            }
            pw.write("method", request.getMethod());
            pw.write("path", request.getPath());
            pw.write("locale", request.getLocale());
            pw.write("serverName", request.getServerName());
            pw.write("remoteHost", request.getRemoteHost());
            writer.printf("%nHeaders:%n%n", new Object[0]);
            for (String name : request.getHeaderNames()) {
                pw.write(name, request.getHeader(name));
            }
            if (!request.getParameterNames().isEmpty()) {
                writer.print("%nParameters:%n");
                for (String name : request.getParameterNames()) {
                    pw.write(name, request.getParameters(name));
                }
            }
            if ((session = request.getSession(false)) != null) {
                pw = this.newPropertyWriter(writer, session.getAttributeNames());
                writer.printf("%nSESSION:%n%n", new Object[0]);
                for (String name : session.getAttributeNames()) {
                    pw.write(name, session.getAttribute(name));
                }
            }
        }
        writer.printf("%nSYSTEM INFORMATION:", new Object[0]);
        Runtime runtime = Runtime.getRuntime();
        writer.printf("%n%nMemory:%n  %,15d bytes free%n  %,15d bytes total%n  %,15d bytes max%n", runtime.freeMemory(), runtime.totalMemory(), runtime.maxMemory());
        Thread[] threads = TapestryInternalUtils.getAllThreads();
        int maxThreadNameLength = 0;
        for (Thread t : threads) {
            maxThreadNameLength = Math.max(maxThreadNameLength, t.getName().length());
        }
        String format = "%n%s %" + maxThreadNameLength + "s %s";
        writer.printf("%n%,d Threads:", threads.length);
        for (Thread t : threads) {
            writer.printf(format, Thread.currentThread() == t ? "*" : " ", t.getName(), t.getState().name());
            if (t.isDaemon()) {
                writer.write(", daemon");
            }
            if (!t.isAlive()) {
                writer.write(", NOT alive");
            }
            if (t.isInterrupted()) {
                writer.write(", interrupted");
            }
            if (t.getPriority() == 5) continue;
            writer.printf(", priority %d", t.getPriority());
        }
        writer.println();
    }

    static interface PropertyWriter {
        public void write(String var1, Object var2);
    }
}

