/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.internal.services.InternalRequestGlobals;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestExceptionHandler;
import org.apache.tapestry5.services.RequestFilter;
import org.apache.tapestry5.services.RequestHandler;
import org.apache.tapestry5.services.Response;

public class RequestErrorFilter
implements RequestFilter {
    private final InternalRequestGlobals internalRequestGlobals;
    private final RequestExceptionHandler exceptionHandler;

    public RequestErrorFilter(InternalRequestGlobals internalRequestGlobals, RequestExceptionHandler exceptionHandler) {
        this.internalRequestGlobals = internalRequestGlobals;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public boolean service(Request request, Response response, RequestHandler handler) throws IOException {
        try {
            return handler.service(request, response);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Throwable exceptionToReport = this.attachNewCause(ex, this.internalRequestGlobals.getClassLoaderException());
            this.exceptionHandler.handleRequestException(exceptionToReport);
            return true;
        }
    }

    private Throwable attachNewCause(Throwable exception, Throwable underlyingCause) {
        if (underlyingCause == null) {
            return exception;
        }
        Throwable current = exception;
        while (current != null) {
            if (current == underlyingCause) {
                return exception;
            }
            Throwable cause = current.getCause();
            if (current == cause) break;
            if (cause == null) {
                try {
                    current.initCause(underlyingCause);
                    return exception;
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
            current = cause;
        }
        return underlyingCause;
    }
}

