/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.pageload;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;

class CompositeRenderCommand
implements RenderCommand {
    private static final RenderQueue NOOP = new RenderQueue(){

        @Override
        public void push(RenderCommand command) {
            this.nyi("push");
        }

        @Override
        public void startComponent(ComponentResources resources) {
            this.nyi("startComponent");
        }

        @Override
        public void endComponent() {
            this.nyi("endComponent");
        }

        private void nyi(String methodName) {
            throw new IllegalStateException(String.format("RenderQueue method %s() is not implemented for composited render commands.", methodName));
        }
    };
    private final RenderCommand[] commands;

    public CompositeRenderCommand(RenderCommand[] commands) {
        this.commands = commands;
    }

    @Override
    public void render(MarkupWriter writer, RenderQueue queue) {
        for (RenderCommand c : this.commands) {
            c.render(writer, NOOP);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CompositeRenderCommand[");
        boolean comma = false;
        for (RenderCommand c : this.commands) {
            if (comma) {
                builder.append(", ");
            }
            builder.append(c);
            comma = true;
        }
        return builder.append("]").toString();
    }
}

