/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.dom;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tapestry5.dom.Attribute;
import org.apache.tapestry5.dom.CData;
import org.apache.tapestry5.dom.Comment;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.dom.EndTagStyle;
import org.apache.tapestry5.dom.MapHolder;
import org.apache.tapestry5.dom.MarkupModel;
import org.apache.tapestry5.dom.Node;
import org.apache.tapestry5.dom.Raw;
import org.apache.tapestry5.dom.Text;
import org.apache.tapestry5.dom.Visitor;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.util.PrintOutCollector;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.Stack;

public final class Element
extends Node {
    private final String name;
    private Node firstChild;
    private Node lastChild;
    private Attribute firstAttribute;
    private final Document document;
    private static final Pattern SPACES = Pattern.compile("\\s+");
    private static final String[] EMPTY_ARRAY = new String[0];
    private final String namespace;
    private Map<String, String> namespaceToPrefix;

    Element(Document container, String namespace, String name) {
        super(null);
        this.document = container;
        this.namespace = namespace;
        this.name = name;
    }

    Element(Element parent, String namespace, String name) {
        super(parent);
        this.namespace = namespace;
        this.name = name;
        this.document = null;
    }

    @Override
    public Document getDocument() {
        return this.document != null ? this.document : super.getDocument();
    }

    public Element attribute(String name, String value) {
        return this.attribute(null, name, value);
    }

    public Element attribute(String namespace, String name, String value) {
        assert (InternalUtils.isNonBlank((String)name));
        this.updateAttribute(namespace, name, value, false);
        return this;
    }

    private void updateAttribute(String namespace, String name, String value, boolean force) {
        if (!force && value == null) {
            return;
        }
        Attribute prior = null;
        Attribute cursor = this.firstAttribute;
        while (cursor != null) {
            if (cursor.matches(namespace, name)) {
                boolean isClass;
                boolean bl = isClass = namespace == null && name.equals("class");
                if (!force && !isClass) {
                    return;
                }
                if (value != null) {
                    cursor.value = !force && isClass ? cursor.value + " " + value : value;
                    return;
                }
                if (prior == null) {
                    this.firstAttribute = cursor.nextAttribute;
                } else {
                    prior.nextAttribute = cursor.nextAttribute;
                }
                return;
            }
            prior = cursor;
            cursor = cursor.nextAttribute;
        }
        if (value != null) {
            this.firstAttribute = new Attribute(this, namespace, name, value, this.firstAttribute);
        }
    }

    public Element attributes(String ... namesAndValues) {
        int i = 0;
        while (i < namesAndValues.length) {
            String name = namesAndValues[i++];
            String value = namesAndValues[i++];
            this.attribute(name, value);
        }
        return this;
    }

    public Element forceAttributes(String ... namesAndValues) {
        return this.forceAttributesNS(null, namesAndValues);
    }

    public Element forceAttributesNS(String namespace, String ... namesAndValues) {
        int i = 0;
        while (i < namesAndValues.length) {
            String name = namesAndValues[i++];
            String value = namesAndValues[i++];
            this.updateAttribute(namespace, name, value, true);
        }
        return this;
    }

    public Element element(String name, String ... namesAndValues) {
        assert (InternalUtils.isNonBlank((String)name));
        Element child = this.newChild(new Element(this, null, name));
        child.attributes(namesAndValues);
        return child;
    }

    public Element elementBefore(String name, String ... namesAndValues) {
        assert (InternalUtils.isNonBlank((String)name));
        Element sibling = this.container.element(name, namesAndValues);
        sibling.moveBefore(this);
        return sibling;
    }

    public Element elementNS(String namespace, String name) {
        assert (InternalUtils.isNonBlank((String)name));
        return this.newChild(new Element(this, namespace, name));
    }

    public Element elementAt(int index, String name, String ... namesAndValues) {
        assert (InternalUtils.isNonBlank((String)name));
        Element child = new Element(this, null, name);
        child.attributes(namesAndValues);
        this.insertChildAt(index, child);
        return child;
    }

    public Element comment(String text) {
        this.newChild(new Comment(this, text));
        return this;
    }

    public Element raw(String text) {
        this.newChild(new Raw(this, text));
        return this;
    }

    public Text text(String text) {
        return this.newChild(new Text(this, text));
    }

    public CData cdata(String content) {
        return this.newChild(new CData(this, content));
    }

    private <T extends Node> T newChild(T child) {
        this.addChild(child);
        return child;
    }

    @Override
    void toMarkup(Document document, PrintWriter writer, Map<String, String> containerNamespacePrefixToURI) {
        Map<String, String> localNamespacePrefixToURI = this.createNamespaceURIToPrefix(containerNamespacePrefixToURI);
        MarkupModel markupModel = document.getMarkupModel();
        StringBuilder builder = new StringBuilder();
        String prefixedElementName = this.toPrefixedName(localNamespacePrefixToURI, this.namespace, this.name);
        builder.append("<").append(prefixedElementName);
        Attribute attr = this.firstAttribute;
        while (attr != null) {
            attr.render(markupModel, builder, localNamespacePrefixToURI);
            attr = attr.nextAttribute;
        }
        List namespaces = InternalUtils.sortedKeys(this.namespaceToPrefix);
        for (String namespace : namespaces) {
            if (namespace.equals("http://www.w3.org/XML/1998/namespace")) continue;
            String prefix = this.namespaceToPrefix.get(namespace);
            builder.append(" xmlns");
            if (!prefix.equals("")) {
                builder.append(":").append(prefix);
            }
            builder.append("=");
            builder.append(markupModel.getAttributeQuote());
            markupModel.encodeQuoted(namespace, builder);
            builder.append(markupModel.getAttributeQuote());
        }
        EndTagStyle style = markupModel.getEndTagStyle(this.name);
        boolean hasChildren = this.hasChildren();
        String close = !hasChildren && style == EndTagStyle.ABBREVIATE ? "/>" : ">";
        builder.append(close);
        writer.print(builder.toString());
        if (hasChildren) {
            this.writeChildMarkup(document, writer, localNamespacePrefixToURI);
        }
        if (hasChildren || style == EndTagStyle.REQUIRE) {
            writer.print("</");
            writer.print(prefixedElementName);
            writer.print(">");
        }
    }

    String toPrefixedName(Map<String, String> namespaceURIToPrefix, String namespace, String name) {
        if (namespace == null || namespace.equals("")) {
            return name;
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml:" + name;
        }
        String prefix = namespaceURIToPrefix.get(namespace);
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("No prefix has been defined for namespace '%s'.", namespace));
        }
        if (prefix.equals("")) {
            return name;
        }
        return prefix + ":" + name;
    }

    public Element getElementById(String id) {
        return this.getElementByAttributeValue("id", id);
    }

    public Element getElementByAttributeValue(final String attributeName, final String attributeValue) {
        assert (attributeName != null);
        assert (attributeValue != null);
        return this.getElement(new Predicate<Element>(){

            public boolean accept(Element e) {
                String elementId = e.getAttribute(attributeName);
                return attributeValue.equals(elementId);
            }
        });
    }

    public Element getElement(Predicate<Element> predicate) {
        LinkedList queue = CollectionFactory.newLinkedList();
        queue.add(this);
        while (!queue.isEmpty()) {
            Element e = (Element)queue.removeFirst();
            if (predicate.accept((Object)e)) {
                return e;
            }
            for (Element child : e.childElements()) {
                queue.addLast(child);
            }
        }
        return null;
    }

    public Element find(String path) {
        String name;
        assert (InternalUtils.isNonBlank((String)path));
        Element search = this;
        String[] arr$ = TapestryInternalUtils.splitPath(path);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (search = search.findChildWithElementName(name = arr$[i$])) != null; ++i$) {
        }
        return search;
    }

    private Element findChildWithElementName(String name) {
        for (Element child : this.childElements()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private Iterable<Element> childElements() {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    private Node cursor;
                    {
                        this.cursor = Element.this.firstChild;
                        this.advance();
                    }

                    private void advance() {
                        while (this.cursor != null) {
                            if (this.cursor instanceof Element) {
                                return;
                            }
                            this.cursor = this.cursor.nextSibling;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.cursor != null;
                    }

                    @Override
                    public Element next() {
                        Element result = (Element)this.cursor;
                        this.cursor = this.cursor.nextSibling;
                        this.advance();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove() not supported.");
                    }
                };
            }
        };
    }

    public String getAttribute(String attributeName) {
        Attribute attr = this.firstAttribute;
        while (attr != null) {
            if (attr.getName().equalsIgnoreCase(attributeName)) {
                return attr.value;
            }
            attr = attr.nextAttribute;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Element addClassName(String ... classNames) {
        for (String name : classNames) {
            this.attribute("class", name);
        }
        return this;
    }

    public Element defineNamespace(String namespace, String namespacePrefix) {
        assert (namespace != null);
        assert (namespacePrefix != null);
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            return this;
        }
        if (this.namespaceToPrefix == null) {
            this.namespaceToPrefix = CollectionFactory.newMap();
        }
        this.namespaceToPrefix.put(namespace, namespacePrefix);
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void pop() {
        List childrenCopy = CollectionFactory.newList(this.getChildren());
        for (Node child : childrenCopy) {
            child.moveBefore(this);
        }
        this.remove();
    }

    public Element removeChildren() {
        this.firstChild = null;
        this.lastChild = null;
        return this;
    }

    private Map<String, String> createNamespaceURIToPrefix(Map<String, String> containerNamespaceURIToPrefix) {
        MapHolder holder = new MapHolder(containerNamespaceURIToPrefix);
        holder.putAll(this.namespaceToPrefix);
        if (InternalUtils.isNonBlank((String)this.namespace) && !holder.getResult().containsKey(this.namespace)) {
            this.defineNamespace(this.namespace, "");
            holder.put(this.namespace, "");
        }
        Attribute attr = this.firstAttribute;
        while (attr != null) {
            this.addMappingIfNeeded(holder, attr.getNamespace());
            attr = attr.nextAttribute;
        }
        return holder.getResult();
    }

    private void addMappingIfNeeded(MapHolder holder, String namespace) {
        if (InternalUtils.isBlank((String)namespace)) {
            return;
        }
        Map<String, String> current = holder.getResult();
        if (current.containsKey(namespace)) {
            return;
        }
        Set prefixes = CollectionFactory.newSet(holder.getResult().values());
        int i = 0;
        while (true) {
            String prefix;
            if (!prefixes.contains(prefix = "ns" + i)) {
                this.defineNamespace(namespace, prefix);
                holder.put(namespace, prefix);
                return;
            }
            ++i;
        }
    }

    @Override
    protected Map<String, String> getNamespaceURIToPrefix() {
        MapHolder holder = new MapHolder();
        List elements = CollectionFactory.newList((Object[])new Element[]{this});
        Element cursor = this.container;
        while (cursor != null) {
            elements.add(cursor);
            cursor = cursor.container;
        }
        Collections.reverse(elements);
        for (Element e : elements) {
            holder.putAll(e.namespaceToPrefix);
        }
        return holder.getResult();
    }

    public boolean isEmpty() {
        List<Node> children = this.getChildren();
        if (children.isEmpty()) {
            return true;
        }
        for (Node n : children) {
            Text t;
            if (n instanceof Text && (t = (Text)n).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void visit(Visitor visitor) {
        Stack queue = CollectionFactory.newStack();
        queue.push((Object)this);
        while (!queue.isEmpty()) {
            Element e = (Element)queue.pop();
            visitor.visit(e);
            e.queueChildren((Stack<Element>)queue);
        }
    }

    private void queueChildren(Stack<Element> queue) {
        if (this.firstChild == null) {
            return;
        }
        List childElements = CollectionFactory.newList();
        Node cursor = this.firstChild;
        while (cursor != null) {
            if (cursor instanceof Element) {
                childElements.add((Element)cursor);
            }
            cursor = cursor.nextSibling;
        }
        Collections.reverse(childElements);
        for (Element e : childElements) {
            queue.push((Object)e);
        }
    }

    void addChild(Node child) {
        child.container = this;
        if (this.lastChild == null) {
            this.firstChild = child;
            this.lastChild = child;
            return;
        }
        this.lastChild.nextSibling = child;
        this.lastChild = child;
    }

    void insertChildAt(int index, Node newChild) {
        newChild.container = this;
        if (index < 1) {
            newChild.nextSibling = this.firstChild;
            this.firstChild = newChild;
        } else {
            Node cursor = this.firstChild;
            for (int i = 1; i < index; ++i) {
                cursor = cursor.nextSibling;
            }
            newChild.nextSibling = cursor.nextSibling;
            cursor.nextSibling = newChild;
        }
        if (index < 1) {
            this.firstChild = newChild;
        }
        if (newChild.nextSibling == null) {
            this.lastChild = newChild;
        }
    }

    boolean hasChildren() {
        return this.firstChild != null;
    }

    void writeChildMarkup(Document document, PrintWriter writer, Map<String, String> namespaceURIToPrefix) {
        Node cursor = this.firstChild;
        while (cursor != null) {
            cursor.toMarkup(document, writer, namespaceURIToPrefix);
            cursor = cursor.nextSibling;
        }
    }

    public final String getChildMarkup() {
        PrintOutCollector collector = new PrintOutCollector();
        this.writeChildMarkup(this.getDocument(), collector.getPrintWriter(), null);
        return collector.getPrintOut();
    }

    public List<Node> getChildren() {
        List result = CollectionFactory.newList();
        Node cursor = this.firstChild;
        while (cursor != null) {
            result.add(cursor);
            cursor = cursor.nextSibling;
        }
        return result;
    }

    void remove(Node node) {
        Node prior = null;
        Node cursor = this.firstChild;
        while (cursor != null) {
            if (cursor == node) {
                Node afterNode = node.nextSibling;
                if (prior != null) {
                    prior.nextSibling = afterNode;
                } else {
                    this.firstChild = afterNode;
                }
                if (this.lastChild == node) {
                    this.lastChild = prior != null ? prior : null;
                }
                node.nextSibling = null;
                return;
            }
            prior = cursor;
            cursor = cursor.nextSibling;
        }
        throw new IllegalArgumentException("Node to remove was not present as a child of this element.");
    }

    void insertChildBefore(Node existing, Node node) {
        int index = this.indexOfNode(existing);
        node.container = this;
        this.insertChildAt(index, node);
    }

    void insertChildAfter(Node existing, Node node) {
        Node oldAfter = existing.nextSibling;
        existing.nextSibling = node;
        node.nextSibling = oldAfter;
        if (oldAfter == null) {
            this.lastChild = node;
        }
        node.container = this;
    }

    int indexOfNode(Node node) {
        int index = 0;
        Node cursor = this.firstChild;
        while (cursor != null) {
            if (node == cursor) {
                return index;
            }
            cursor = cursor.nextSibling;
            ++index;
        }
        throw new IllegalArgumentException("Node not a child of this element.");
    }

    public Collection<Attribute> getAttributes() {
        List result = CollectionFactory.newList();
        Attribute a = this.firstAttribute;
        while (a != null) {
            result.add(a);
            a = a.nextAttribute;
        }
        return result;
    }
}

