/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.corelib.data.BlankOption;
import org.apache.tapestry5.corelib.data.SecureOption;
import org.apache.tapestry5.corelib.mixins.RenderDisabled;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.internal.util.SelectModelRenderer;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.EnumSelectModel;

public class Select
extends AbstractField {
    public static final String CHANGE_EVENT = "change";
    @Parameter
    private ValueEncoder encoder;
    @Parameter(value="symbol:tapestry.components.validate_with_model", defaultPrefix="literal")
    private SecureOption secure;
    @Parameter(value="false")
    private boolean raw;
    @Parameter(required=true, allowNull=false)
    private SelectModel model;
    @Parameter(value="auto", defaultPrefix="literal")
    private BlankOption blankOption;
    @Parameter(defaultPrefix="literal")
    private String blankLabel;
    @Inject
    private Request request;
    @Environmental
    private ValidationTracker tracker;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(required=true, principal=true, autoconnect=true)
    private Object value;
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Parameter
    private Object[] context;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    @Environmental
    private FormSupport formSupport;
    @Inject
    private JavaScriptSupport javascriptSupport;
    @Mixin
    private RenderDisabled renderDisabled;
    private String selectedClientValue;

    private boolean isSelected(String clientValue) {
        return TapestryInternalUtils.isEqual(clientValue, this.selectedClientValue);
    }

    @Override
    protected void processSubmission(String controlName) {
        Object selectedValue;
        String submittedValue = this.request.getParameter(controlName);
        this.tracker.recordInput(this, submittedValue);
        try {
            selectedValue = this.toValue(submittedValue);
        }
        catch (ValidationException ex) {
            this.tracker.recordError(this, ex.getMessage());
            return;
        }
        this.putPropertyNameIntoBeanValidationContext("value");
        try {
            this.fieldValidationSupport.validate(selectedValue, this.resources, this.validate);
            this.value = selectedValue;
        }
        catch (ValidationException ex) {
            this.tracker.recordError(this, ex.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("select", "name", this.getControlName(), "id", this.getClientId(), "class", this.cssClass);
        this.putPropertyNameIntoBeanValidationContext("value");
        this.validate.render(writer);
        this.removePropertyNameFromBeanValidationContext();
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
        if (this.zone != null) {
            this.javaScriptSupport.require("t5/core/select");
            Link link = this.resources.createEventLink(CHANGE_EVENT, this.context);
            writer.attributes("data-update-zone", this.zone, "data-update-url", link);
        }
    }

    Object onChange(List<Context> context, @RequestParameter(value="t:selectvalue", allowBlank=true) String selectValue) throws ValidationException {
        Object newValue = this.toValue(selectValue);
        CaptureResultCallback callback = new CaptureResultCallback();
        Object[] newContext = new Object[context.size() + 1];
        newContext[0] = newValue;
        for (int i = 1; i < newContext.length; ++i) {
            newContext[i] = context.get(i - 1);
        }
        this.resources.triggerEvent("valueChanged", newContext, callback);
        this.value = newValue;
        return callback.getResult();
    }

    protected Object toValue(String submittedValue) throws ValidationException {
        if (InternalUtils.isBlank((String)submittedValue)) {
            return null;
        }
        if (this.secure == SecureOption.NEVER || this.secure == SecureOption.AUTO && this.model == null) {
            return this.encoder.toValue(submittedValue);
        }
        if (this.model == null) {
            throw new ValidationException("Model is null when validating submitted option. To fix: persist the SeletModel or recreate it upon form submission, or change the 'secure' parameter.");
        }
        return this.findValueInModel(submittedValue);
    }

    private Object findValueInModel(String submittedValue) throws ValidationException {
        Object asSubmitted = this.encoder.toValue(submittedValue);
        if (this.findInOptions(this.model.getOptions(), asSubmitted)) {
            return asSubmitted;
        }
        if (this.model.getOptionGroups() != null) {
            for (OptionGroupModel og : this.model.getOptionGroups()) {
                if (!this.findInOptions(og.getOptions(), asSubmitted)) continue;
                return asSubmitted;
            }
        }
        throw new ValidationException("Selected option is not listed in the model.");
    }

    private boolean findInOptions(List<OptionModel> options, Object asSubmitted) {
        if (options == null) {
            return false;
        }
        boolean alsoCompareDecodedModelValue = !(asSubmitted instanceof String);
        for (OptionModel om : options) {
            Object decodedModelValue;
            Object modelValue = om.getValue();
            if (modelValue.equals(asSubmitted)) {
                return true;
            }
            if (!alsoCompareDecodedModelValue || !(modelValue instanceof String) || !(decodedModelValue = this.encoder.toValue(modelValue.toString())).equals(asSubmitted)) continue;
            return true;
        }
        return false;
    }

    private static <T> List<T> orEmpty(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    SelectModel defaultModel() {
        Class valueType = this.resources.getBoundType("value");
        if (valueType == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(valueType)) {
            return new EnumSelectModel(valueType, this.resources.getContainerMessages());
        }
        return null;
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    Object defaultBlankLabel() {
        String key;
        Messages containerMessages = this.resources.getContainerMessages();
        if (containerMessages.contains(key = this.resources.getId() + "-blanklabel")) {
            return containerMessages.get(key);
        }
        return null;
    }

    @BeforeRenderTemplate
    void options(MarkupWriter writer) {
        this.selectedClientValue = this.tracker.getInput(this);
        if (this.selectedClientValue == null) {
            String string = this.selectedClientValue = this.value == null ? null : this.encoder.toClient(this.value);
        }
        if (this.showBlankOption()) {
            writer.element("option", "value", "");
            writer.write(this.blankLabel);
            writer.end();
        }
        Renderer renderer = new Renderer(writer);
        this.model.visit(renderer);
    }

    @Override
    public boolean isRequired() {
        return this.validate.isRequired();
    }

    private boolean showBlankOption() {
        switch (this.blankOption) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return !this.isRequired();
    }

    void setModel(SelectModel model) {
        this.model = model;
        this.blankOption = BlankOption.NEVER;
    }

    void setValue(Object value) {
        this.value = value;
    }

    void setValueEncoder(ValueEncoder encoder) {
        this.encoder = encoder;
    }

    void setValidationTracker(ValidationTracker tracker) {
        this.tracker = tracker;
    }

    void setBlankOption(BlankOption option, String label) {
        this.blankOption = option;
        this.blankLabel = label;
    }

    void setRaw(boolean b) {
        this.raw = b;
    }

    private class Renderer
    extends SelectModelRenderer {
        public Renderer(MarkupWriter writer) {
            super(writer, Select.this.encoder, Select.this.raw);
        }

        @Override
        protected boolean isOptionSelected(OptionModel optionModel, String clientValue) {
            return Select.this.isSelected(clientValue);
        }
    }
}

