/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.corelib.internal.ComponentActionSink;
import org.apache.tapestry5.corelib.internal.FormSupportAdapter;
import org.apache.tapestry5.corelib.internal.HiddenFieldPositioner;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ClientDataEncoder;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.HiddenFieldLocationRules;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.slf4j.Logger;

@SupportsInformalParameters
@Import(module={"t5/core/form-fragment"})
public class FormFragment
implements ClientElement {
    @Parameter
    private boolean visible;
    @Parameter
    private boolean alwaysSubmit;
    @Parameter(defaultPrefix="literal")
    private String show;
    @Parameter(defaultPrefix="literal")
    private String hide;
    @Parameter(defaultPrefix="literal")
    private String element;
    @Parameter(name="id", defaultPrefix="literal")
    private String idParameter;
    @Parameter(defaultPrefix="literal", allowNull=false)
    private String visibleBound;
    @Inject
    private Environment environment;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private ComponentResources resources;
    private String clientId;
    private ComponentActionSink componentActions;
    @Inject
    private Logger logger;
    @Inject
    private HiddenFieldLocationRules rules;
    private HiddenFieldPositioner hiddenFieldPositioner;
    @Inject
    private ClientDataEncoder clientDataEncoder;

    String defaultElement() {
        return this.resources.getElementName("div");
    }

    void beginRender(MarkupWriter writer) {
        FormSupport formSupport = this.environment.peekRequired(FormSupport.class);
        this.clientId = this.resources.isBound("id") ? this.idParameter : this.javascriptSupport.allocateClientId(this.resources);
        this.hiddenFieldPositioner = new HiddenFieldPositioner(writer, this.rules);
        Element element = writer.element(this.element, "id", this.clientId, "data-component-type", "core/FormFragment");
        this.resources.renderInformalParameters(writer);
        if (!this.visible) {
            element.attribute("style", "display: none;");
        }
        this.componentActions = new ComponentActionSink(this.logger, this.clientDataEncoder);
        FormSupportAdapter override = new FormSupportAdapter(formSupport){

            @Override
            public <T> void store(T component, ComponentAction<T> action) {
                FormFragment.this.componentActions.store(component, action);
            }

            @Override
            public <T> void storeCancel(T component, ComponentAction<T> action) {
                FormFragment.this.componentActions.storeCancel(component, action);
            }

            @Override
            public <T> void storeAndExecute(T component, ComponentAction<T> action) {
                FormFragment.this.componentActions.store(component, action);
                action.execute(component);
            }
        };
        this.environment.push(FormSupport.class, override);
    }

    void afterRender(MarkupWriter writer) {
        Element hidden = this.hiddenFieldPositioner.getElement();
        hidden.attributes("type", "hidden", "name", "t:formdata", "value", this.componentActions.getClientData());
        if (!this.alwaysSubmit) {
            hidden.attributes("data-for-fragment", this.clientId);
        }
        writer.end();
        this.environment.pop(FormSupport.class);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }
}

