/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.BaseOptimizedSessionPersistedObject;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.Field2;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public final class ValidationTrackerImpl
extends BaseOptimizedSessionPersistedObject
implements ValidationTracker,
Serializable {
    private static final long serialVersionUID = -8029192726659275677L;
    private List<String> extraErrors;
    private List<FieldTracker> fieldTrackers;
    private transient Map<String, FieldTracker> fieldToTracker;

    private void refreshFieldToTracker() {
        if (this.fieldToTracker != null) {
            return;
        }
        if (this.fieldTrackers == null) {
            return;
        }
        this.fieldToTracker = CollectionFactory.newMap();
        for (FieldTracker ft : this.fieldTrackers) {
            this.fieldToTracker.put(ft.validationId, ft);
        }
    }

    private String getKey(Field field) {
        if (field instanceof Field2) {
            Field2 field2 = (Field2)field;
            return field2.getValidationId();
        }
        return field.getControlName();
    }

    private FieldTracker get(Field field) {
        String key = this.getKey(field);
        this.refreshFieldToTracker();
        FieldTracker result = (FieldTracker)InternalUtils.get(this.fieldToTracker, (Object)key);
        if (result == null) {
            result = new FieldTracker(key);
        }
        return result;
    }

    private void store(FieldTracker fieldTracker) {
        if (this.fieldTrackers == null) {
            this.fieldTrackers = CollectionFactory.newList();
        }
        this.refreshFieldToTracker();
        String key = fieldTracker.validationId;
        if (!this.fieldToTracker.containsKey(key)) {
            this.fieldTrackers.add(fieldTracker);
            this.fieldToTracker.put(key, fieldTracker);
        }
        this.markDirty();
    }

    @Override
    public void clear() {
        this.extraErrors = null;
        this.fieldTrackers = null;
        this.fieldToTracker = null;
        this.markDirty();
    }

    @Override
    public String getError(Field field) {
        return this.get(field).errorMessage;
    }

    @Override
    public List<String> getErrors() {
        List result = CollectionFactory.newList();
        if (this.extraErrors != null) {
            result.addAll(this.extraErrors);
        }
        if (this.fieldTrackers != null) {
            for (FieldTracker ft : this.fieldTrackers) {
                String errorMessage = ft.errorMessage;
                if (errorMessage == null) continue;
                result.add(errorMessage);
            }
        }
        return result;
    }

    @Override
    public List<String> getUnassociatedErrors() {
        if (this.extraErrors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.extraErrors);
    }

    @Override
    public boolean getHasErrors() {
        return !this.getErrors().isEmpty();
    }

    @Override
    public String getInput(Field field) {
        return this.get(field).input;
    }

    @Override
    public boolean inError(Field field) {
        return InternalUtils.isNonBlank((String)this.get(field).errorMessage);
    }

    @Override
    public void recordError(Field field, String errorMessage) {
        FieldTracker ft = this.get(field);
        ft.errorMessage = errorMessage;
        this.store(ft);
    }

    @Override
    public void recordError(String errorMessage) {
        if (this.extraErrors == null) {
            this.extraErrors = CollectionFactory.newList();
        }
        this.extraErrors.add(errorMessage);
        this.markDirty();
    }

    @Override
    public void recordInput(Field field, String input) {
        FieldTracker ft = this.get(field);
        ft.input = input;
        this.store(ft);
    }

    private static class FieldTracker
    implements Serializable {
        private static final long serialVersionUID = -3653306147088451811L;
        private final String validationId;
        private String input;
        private String errorMessage;

        FieldTracker(String validationId) {
            this.validationId = validationId;
        }
    }
}

