/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.RegistryBuilder;
import org.apache.tapestry5.ioc.junit.ModuleDef;
import org.apache.tapestry5.ioc.junit.RegistryShutdownType;
import org.junit.runners.model.InitializationError;

public class TestRegistryManager {
    private final org.apache.tapestry5.ioc.junit.Registry annotation;
    private final List<Method> moduleDefFactories;
    private Registry registry;

    public TestRegistryManager(Class<?> type) throws InitializationError {
        org.apache.tapestry5.ioc.junit.Registry annotation = type.getAnnotation(org.apache.tapestry5.ioc.junit.Registry.class);
        if (annotation == null) {
            throw new InitializationError(type.getName() + " does not specify a @Registry");
        }
        this.annotation = annotation;
        this.moduleDefFactories = this.findModuleDefFactories(type);
    }

    protected List<Method> findModuleDefFactories(Class<?> type) throws InitializationError {
        ArrayList factoryMethods = new ArrayList();
        for (Method method : type.getMethods()) {
            if (method.getAnnotation(ModuleDef.class) == null) continue;
            this.validateModuleDefMethod(method);
            factoryMethods.add(method);
        }
        return factoryMethods.isEmpty() ? Collections.emptyList() : factoryMethods;
    }

    protected void validateModuleDefMethod(Method method) throws InitializationError {
        int modifiers = method.getModifiers();
        if (method.getParameterTypes().length != 0 || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new InitializationError(String.format("@ModuleDef method %s must be public static and accept no arguments", method.getName()));
        }
        if (!org.apache.tapestry5.ioc.def.ModuleDef.class.isAssignableFrom(method.getReturnType())) {
            throw new InitializationError(String.format("@ModuleDef method %s return type %s is not valid", method.getName(), method.getReturnType().getName()));
        }
    }

    public Registry getOrCreateRegistry() throws Exception {
        if (this.registry == null) {
            RegistryBuilder builder = new RegistryBuilder();
            if (this.annotation.modules() != null) {
                builder.add((Class[])this.annotation.modules());
            }
            for (Method moduleDefFactory : this.moduleDefFactories) {
                try {
                    org.apache.tapestry5.ioc.def.ModuleDef moduleDef = (org.apache.tapestry5.ioc.def.ModuleDef)moduleDefFactory.invoke(null, new Object[0]);
                    builder.add(moduleDef);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof Exception) {
                        throw (Exception)e.getTargetException();
                    }
                    throw e;
                }
            }
            this.registry = builder.build();
            this.registry.performRegistryStartup();
        }
        return this.registry;
    }

    public void afterTestMethod() {
        if (this.annotation.shutdown() == RegistryShutdownType.AFTER_METHOD) {
            this.shutdownRegistry();
        }
    }

    public void afterTestClass() {
        if (this.annotation.shutdown() == RegistryShutdownType.AFTER_CLASS) {
            this.shutdownRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownRegistry() {
        try {
            this.registry.shutdown();
        }
        finally {
            this.registry = null;
        }
    }
}

