/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CaseInsensitiveMap<V>
extends AbstractMap<String, V>
implements Serializable {
    private static final long serialVersionUID = 3362718337611953298L;
    private static final int NULL_HASH = Integer.MIN_VALUE;
    private static final int DEFAULT_SIZE = 20;
    private CIMEntry<V>[] entries;
    private int size = 0;
    private transient int modCount = 0;
    private transient Set<Map.Entry<String, V>> entrySet;

    public CaseInsensitiveMap() {
        this(20);
    }

    public CaseInsensitiveMap(int size) {
        this.entries = new CIMEntry[Math.max(size, 3)];
    }

    public CaseInsensitiveMap(Map<String, ? extends V> map) {
        this(map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.entries[i] = null;
        }
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V put(String key, V value) {
        int hashCode = CaseInsensitiveMap.caseInsenitiveHashCode(key);
        return this.select(key, hashCode).put(key, hashCode, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.select(key).isFound();
    }

    @Override
    public V get(Object key) {
        return this.select(key).get();
    }

    @Override
    public V remove(Object key) {
        return this.select(key).remove();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private Position select(Object key) {
        if (key == null || key instanceof String) {
            String keyString = (String)key;
            return this.select(keyString, CaseInsensitiveMap.caseInsenitiveHashCode(keyString));
        }
        return new Position(0, false);
    }

    private Position select(String key, int hashCode) {
        if (this.size == 0) {
            return new Position(0, false);
        }
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int cursor = low + high >> 1;
            CIMEntry<V> e = this.entries[cursor];
            if (((CIMEntry)e).hashCode < hashCode) {
                low = cursor + 1;
                continue;
            }
            if (((CIMEntry)e).hashCode > hashCode) {
                high = cursor - 1;
                continue;
            }
            return this.tunePosition(key, hashCode, cursor);
        }
        return new Position(low, false);
    }

    private Position tunePosition(String key, int hashCode, int cursor) {
        boolean found = false;
        while (cursor > 0 && ((CIMEntry)this.entries[cursor - 1]).hashCode == hashCode) {
            --cursor;
        }
        do {
            if (!this.entries[cursor].matches(key)) continue;
            found = true;
            break;
        } while (++cursor < this.size && ((CIMEntry)this.entries[cursor]).hashCode == hashCode);
        return new Position(cursor, found);
    }

    static int caseInsenitiveHashCode(String input) {
        if (input == null) {
            return Integer.MIN_VALUE;
        }
        int length = input.length();
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            int caselessCh = Character.toLowerCase((int)ch);
            hash = 31 * hash + caselessCh;
        }
        return hash;
    }

    static /* synthetic */ CIMEntry[] access$202(CaseInsensitiveMap x0, CIMEntry[] x1) {
        x0.entries = x1;
        return x1;
    }

    private class Position {
        private final int cursor;
        private final boolean found;

        Position(int cursor, boolean found) {
            this.cursor = cursor;
            this.found = found;
        }

        boolean isFound() {
            return this.found;
        }

        CIMEntry<V> entry() {
            return CaseInsensitiveMap.this.entries[this.cursor];
        }

        V get() {
            return this.found ? (Object)((CaseInsensitiveMap)CaseInsensitiveMap.this).entries[this.cursor].value : null;
        }

        V remove() {
            if (!this.found) {
                return null;
            }
            Object result = ((CaseInsensitiveMap)CaseInsensitiveMap.this).entries[this.cursor].value;
            System.arraycopy(CaseInsensitiveMap.this.entries, this.cursor + 1, CaseInsensitiveMap.this.entries, this.cursor, CaseInsensitiveMap.this.size - this.cursor - 1);
            ((CaseInsensitiveMap)CaseInsensitiveMap.this).entries[--((CaseInsensitiveMap)CaseInsensitiveMap.this).size] = null;
            CaseInsensitiveMap.this.modCount++;
            return result;
        }

        V put(String key, int hashCode, V newValue) {
            CIMEntry newEntry;
            if (this.found) {
                CIMEntry e = CaseInsensitiveMap.this.entries[this.cursor];
                Object result = e.value;
                e.key = key;
                e.value = newValue;
                return result;
            }
            int newSize = CaseInsensitiveMap.this.size + 1;
            if (newSize == CaseInsensitiveMap.this.entries.length) {
                int newCapacity = CaseInsensitiveMap.this.size * 3 / 2 + 1;
                CIMEntry[] newEntries = new CIMEntry[newCapacity];
                System.arraycopy(CaseInsensitiveMap.this.entries, 0, newEntries, 0, this.cursor);
                System.arraycopy(CaseInsensitiveMap.this.entries, this.cursor, newEntries, this.cursor + 1, CaseInsensitiveMap.this.size - this.cursor);
                CaseInsensitiveMap.access$202(CaseInsensitiveMap.this, newEntries);
            } else {
                System.arraycopy(CaseInsensitiveMap.this.entries, this.cursor, CaseInsensitiveMap.this.entries, this.cursor + 1, CaseInsensitiveMap.this.size - this.cursor);
            }
            ((CaseInsensitiveMap)CaseInsensitiveMap.this).entries[this.cursor] = newEntry = new CIMEntry(key, hashCode, newValue);
            CaseInsensitiveMap.this.size++;
            CaseInsensitiveMap.this.modCount++;
            return null;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return CaseInsensitiveMap.this.size;
        }

        @Override
        public void clear() {
            CaseInsensitiveMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Position position = CaseInsensitiveMap.this.select(e.getKey());
            return position.isFound() && position.entry().valueMatches(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Position position = CaseInsensitiveMap.this.select(e.getKey());
            if (position.isFound() && position.entry().valueMatches(e.getValue())) {
                position.remove();
                return true;
            }
            return false;
        }
    }

    private class EntrySetIterator
    implements Iterator {
        int expectedModCount;
        int index;
        int current;

        private EntrySetIterator() {
            this.expectedModCount = CaseInsensitiveMap.this.modCount;
            this.current = -1;
        }

        @Override
        public boolean hasNext() {
            return this.index < CaseInsensitiveMap.this.size;
        }

        public Object next() {
            this.check();
            if (this.index >= CaseInsensitiveMap.this.size) {
                throw new NoSuchElementException();
            }
            this.current = this.index++;
            return CaseInsensitiveMap.this.entries[this.current];
        }

        @Override
        public void remove() {
            this.check();
            if (this.current < 0) {
                throw new NoSuchElementException();
            }
            new Position(this.current, true).remove();
            this.expectedModCount = CaseInsensitiveMap.this.modCount;
        }

        private void check() {
            if (this.expectedModCount != CaseInsensitiveMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class CIMEntry<V>
    implements Map.Entry<String, V>,
    Serializable {
        private static final long serialVersionUID = 6713986085221148350L;
        private String key;
        private final int hashCode;
        V value;

        public CIMEntry(String key, int hashCode, V value) {
            this.key = key;
            this.hashCode = hashCode;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }

        boolean matches(String key) {
            return key == this.key || key != null && key.equalsIgnoreCase(this.key);
        }

        boolean valueMatches(Object value) {
            return value == this.value || value != null && value.equals(this.value);
        }
    }
}

