/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Locatable;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.NullAnnotationProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

public class InternalCommonsUtils {
    public static final AnnotationProvider NULL_ANNOTATION_PROVIDER = new NullAnnotationProvider();
    private static final Pattern NON_WORD_PATTERN = Pattern.compile("[^\\w]");
    static final Pattern NAME_PATTERN = Pattern.compile("^[_|$]*([\\p{javaJavaIdentifierPart}]+?)[_|$]*$", 2);

    public static <K, V> void addToMapList(Map<K, List<V>> map, K key, V value) {
        List<Object> list = map.get(key);
        if (list == null) {
            list = CollectionFactory.newList();
            map.put(key, list);
        }
        list.add(value);
    }

    public static Location locationOf(Object location) {
        if (location == null) {
            return null;
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        if (location instanceof Locatable) {
            return ((Locatable)location).getLocation();
        }
        return null;
    }

    public static AnnotationProvider toAnnotationProvider(final Method element) {
        if (element == null) {
            return NULL_ANNOTATION_PROVIDER;
        }
        return new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return element.getAnnotation(annotationClass);
            }
        };
    }

    public static String extractIdFromPropertyExpression(String expression) {
        return InternalCommonsUtils.replace(expression, NON_WORD_PATTERN, "");
    }

    public static String replace(String input, Pattern pattern, String replacement) {
        return pattern.matcher(input).replaceAll(replacement);
    }

    public static String defaultLabel(String id, Messages messages, String propertyExpression) {
        String key = id + "-label";
        if (messages.contains(key)) {
            return messages.get(key);
        }
        return InternalCommonsUtils.toUserPresentable(InternalCommonsUtils.extractIdFromPropertyExpression(InternalCommonsUtils.lastTerm(propertyExpression)));
    }

    public static String toUserPresentable(String id) {
        StringBuilder builder = new StringBuilder(id.length() * 2);
        char[] chars = id.toCharArray();
        boolean postSpace = true;
        boolean upcaseNext = true;
        for (char ch : chars) {
            if (upcaseNext) {
                builder.append(Character.toUpperCase(ch));
                upcaseNext = false;
                continue;
            }
            if (ch == '_') {
                builder.append(' ');
                upcaseNext = true;
                continue;
            }
            boolean upperCase = Character.isUpperCase(ch);
            if (upperCase && !postSpace) {
                builder.append(' ');
            }
            builder.append(ch);
            postSpace = upperCase;
        }
        return builder.toString();
    }

    public static AnnotationProvider toAnnotationProvider(final Class element) {
        return new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)((Annotation)annotationClass.cast(element.getAnnotation(annotationClass)));
            }
        };
    }

    public static String asString(Method method) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.getDeclaringClass().getName());
        buffer.append(".");
        buffer.append(method.getName());
        buffer.append("(");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            String name = method.getParameterTypes()[i].getSimpleName();
            buffer.append(name);
        }
        return buffer.append(")").toString();
    }

    public static String stripMemberName(String memberName) {
        assert (InternalCommonsUtils.isNonBlank(memberName));
        Matcher matcher = NAME_PATTERN.matcher(memberName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Input '%s' is not a valid Java identifier.", memberName));
        }
        return matcher.group(1);
    }

    public static String join(List elements) {
        return InternalCommonsUtils.join(elements, ", ");
    }

    public static String join(List elements, String separator) {
        switch (elements.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return elements.get(0).toString();
            }
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Object o : elements) {
            String string;
            if (!first) {
                buffer.append(separator);
            }
            if ((string = String.valueOf(o)).equals("")) {
                string = "(blank)";
            }
            buffer.append(string);
            first = false;
        }
        return buffer.toString();
    }

    public static String joinSorted(Collection elements) {
        if (elements == null || elements.isEmpty()) {
            return "(none)";
        }
        List list = CollectionFactory.newList();
        for (Object o : elements) {
            list.add(String.valueOf(o));
        }
        Collections.sort(list);
        return InternalCommonsUtils.join(list);
    }

    public static boolean isBlank(String input) {
        return input == null || input.length() == 0 || input.trim().length() == 0;
    }

    public static String capitalize(String input) {
        if (input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static boolean isNonBlank(String input) {
        return !InternalCommonsUtils.isBlank(input);
    }

    public static boolean containsSymbols(String input) {
        return input.contains("${");
    }

    public static String lastTerm(String input) {
        assert (InternalCommonsUtils.isNonBlank(input));
        int dotx = input.lastIndexOf(46);
        if (dotx < 0) {
            return input;
        }
        return input.substring(dotx + 1);
    }

    public static List<String> sortedKeys(Map map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<String> keys = CollectionFactory.newList();
        for (Object o : map.keySet()) {
            keys.add(String.valueOf(o));
        }
        Collections.sort(keys);
        return keys;
    }
}

