/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.validator;

import java.util.regex.Pattern;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.validator.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
extends AbstractValidator<Void, String> {
    private static final String ATOM = "[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]";
    private static final String DOMAIN = "([^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]+(\\.[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]+)*";
    private static final String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private static final Pattern PATTERN = Pattern.compile("^[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]+(\\.[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]+)*@([^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]+(\\.[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]+)*|\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])$", 2);

    public Email() {
        super(null, String.class, "invalid-email");
    }

    @Override
    public void render(Field field, Void constraintValue, MessageFormatter formatter, MarkupWriter markupWriter, FormSupport formSupport) {
    }

    private String buildMessage(MessageFormatter formatter, Field field) {
        return formatter.format(new Object[]{field.getLabel()});
    }

    @Override
    public void validate(Field field, Void constraintValue, MessageFormatter formatter, String value) throws ValidationException {
        if (!PATTERN.matcher(value).matches()) {
            throw new ValidationException(this.buildMessage(formatter, field));
        }
    }
}

