/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.tree;

import java.util.Set;
import org.apache.tapestry5.BaseOptimizedSessionPersistedObject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.tree.TreeExpansionModel;
import org.apache.tapestry5.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeExpansionModel<T>
extends BaseOptimizedSessionPersistedObject
implements TreeExpansionModel<T> {
    private final Set<String> expandedIds = CollectionFactory.newSet();

    @Override
    public boolean isExpanded(TreeNode<T> node) {
        assert (node != null);
        return this.expandedIds.contains(node.getId());
    }

    @Override
    public void markExpanded(TreeNode<T> node) {
        assert (node != null);
        if (this.expandedIds.add(node.getId())) {
            this.markDirty();
        }
    }

    @Override
    public void markCollapsed(TreeNode<T> node) {
        assert (node != null);
        if (this.expandedIds.remove(node.getId())) {
            this.markDirty();
        }
    }

    @Override
    public void clear() {
        if (!this.expandedIds.isEmpty()) {
            this.expandedIds.clear();
            this.markDirty();
        }
    }
}

