/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.javascript;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.javascript.StylesheetOptions;

public final class StylesheetLink {
    private final String url;
    private final StylesheetOptions options;
    private static final StylesheetOptions BLANK_OPTIONS = new StylesheetOptions(null);

    public StylesheetLink(Asset asset) {
        this(asset, null);
    }

    public StylesheetLink(Asset asset, StylesheetOptions options) {
        this(asset.toClientURL(), options);
    }

    public StylesheetLink(String url) {
        this(url, null);
    }

    public StylesheetLink(String url, StylesheetOptions options) {
        assert (InternalUtils.isNonBlank((String)url));
        this.url = url;
        this.options = options != null ? options : BLANK_OPTIONS;
    }

    public String getURL() {
        return this.url;
    }

    public StylesheetOptions getOptions() {
        return this.options;
    }

    public void add(Element container) {
        String condition = this.options.getCondition();
        boolean hasCondition = InternalUtils.isNonBlank((String)condition);
        if (hasCondition) {
            container.raw(String.format("\n<!--[if %s]>\n", condition));
        }
        String rel = this.options.ajaxInsertionPoint ? "stylesheet t-ajax-insertion-point" : "stylesheet";
        container.element("link", "href", this.url, "rel", rel, "type", "text/css", "media", this.options.media);
        if (hasCondition) {
            container.raw("\n<![endif]-->\n");
        }
    }

    public String toString() {
        return String.format("StylesheetLink[%s %s]", this.url, this.options);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StylesheetLink)) {
            return false;
        }
        StylesheetLink ssl = (StylesheetLink)obj;
        return TapestryInternalUtils.isEqual(this.url, ssl.url) && TapestryInternalUtils.isEqual(this.options, ssl.options);
    }
}

