/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services;

import java.lang.reflect.Modifier;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformMethodSignature
implements Comparable<TransformMethodSignature> {
    private int hashCode = -1;
    private final int modifiers;
    private final String returnType;
    private final String methodName;
    private final String signature;
    private final String[] parameterTypes;
    private final String[] exceptionTypes;

    public TransformMethodSignature(String name) {
        this(1, "void", name, InternalConstants.EMPTY_STRING_ARRAY, InternalConstants.EMPTY_STRING_ARRAY);
    }

    public TransformMethodSignature(int modifiers, String type, String name, String[] parameterTypes, String[] exceptionTypes) {
        this(modifiers, type, null, name, parameterTypes, exceptionTypes);
    }

    public TransformMethodSignature(int modifiers, String type, String signature, String name, String[] parameterTypes, String[] exceptionTypes) {
        assert (InternalUtils.isNonBlank((String)name));
        assert (InternalUtils.isNonBlank((String)type));
        this.modifiers = modifiers;
        this.signature = signature;
        this.returnType = type;
        this.methodName = name;
        this.parameterTypes = this.typeNamesOrEmpty(parameterTypes);
        this.exceptionTypes = this.typeNamesOrEmpty(exceptionTypes);
    }

    private String[] typeNamesOrEmpty(String[] types) {
        return types == null ? InternalConstants.EMPTY_STRING_ARRAY : types;
    }

    public String[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getSignature() {
        return this.signature;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 17 * this.modifiers;
            this.hashCode += 31 * this.returnType.hashCode();
            this.hashCode += 31 * this.methodName.hashCode();
            for (String parameterType : this.parameterTypes) {
                this.hashCode += 31 * parameterType.hashCode();
            }
            for (String exceptionType : this.exceptionTypes) {
                this.hashCode += 31 * exceptionType.hashCode();
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof TransformMethodSignature)) {
            return false;
        }
        TransformMethodSignature ms = (TransformMethodSignature)other;
        return this.modifiers == ms.modifiers && this.returnType.equals(ms.returnType) && this.methodName.equals(ms.methodName) && this.matches(this.parameterTypes, ms.parameterTypes) && this.matches(this.exceptionTypes, ms.exceptionTypes);
    }

    private boolean matches(String[] values, String[] otherValues) {
        if (values.length != otherValues.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals(otherValues[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.modifiers != 0) {
            builder.append(Modifier.toString(this.modifiers));
            builder.append(' ');
        }
        builder.append(this.returnType);
        builder.append(' ');
        this.addMethodNameAndParameters(builder);
        for (int i = 0; i < this.exceptionTypes.length; ++i) {
            if (i == 0) {
                builder.append(" throws ");
            } else {
                builder.append(", ");
            }
            builder.append(this.exceptionTypes[i]);
        }
        return builder.toString();
    }

    private void addMethodNameAndParameters(StringBuilder builder) {
        builder.append(this.methodName);
        builder.append('(');
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.parameterTypes[i]);
        }
        builder.append(')');
    }

    @Override
    public int compareTo(TransformMethodSignature o) {
        int result = this.methodName.compareTo(o.methodName);
        if (result == 0) {
            result = o.parameterTypes.length - this.parameterTypes.length;
        }
        return result;
    }

    public String getMediumDescription() {
        StringBuilder builder = new StringBuilder();
        this.addMethodNameAndParameters(builder);
        return builder.toString();
    }
}

