/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.translator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.internal.translator.BigDecimalNumericFormatter;
import org.apache.tapestry5.internal.translator.BigIntegerNumericFormatter;
import org.apache.tapestry5.internal.translator.NumericFormatter;
import org.apache.tapestry5.internal.translator.NumericFormatterImpl;
import org.apache.tapestry5.internal.translator.NumericTranslatorSupport;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericTranslatorSupportImpl
implements NumericTranslatorSupport {
    private final TypeCoercer typeCoercer;
    private final ThreadLocale threadLocale;
    private final Request request;
    private final JavaScriptSupport javascriptSupport;
    private final ClientBehaviorSupport clientBehaviorSupport;
    private final boolean compactJSON;
    private final Map<Locale, DecimalFormatSymbols> symbolsCache = CollectionFactory.newConcurrentMap();
    private final Set<Class> integerTypes = CollectionFactory.newSet();
    private static final String DECIMAL_FORMAT_SYMBOLS_PROVIDED = "tapestry.decimal-format-symbols-provided";

    public NumericTranslatorSupportImpl(TypeCoercer typeCoercer, ThreadLocale threadLocale, Request request, JavaScriptSupport javascriptSupport, ClientBehaviorSupport clientBehaviorSupport, @Symbol(value="tapestry.compact-json") boolean compactJSON) {
        Class[] integerTypes;
        this.typeCoercer = typeCoercer;
        this.threadLocale = threadLocale;
        this.request = request;
        this.javascriptSupport = javascriptSupport;
        this.clientBehaviorSupport = clientBehaviorSupport;
        this.compactJSON = compactJSON;
        for (Class c : integerTypes = new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}) {
            this.integerTypes.add(c);
        }
    }

    @Override
    public <T extends Number> void addValidation(Class<T> type, Field field, String message) {
        if (this.request.getAttribute(DECIMAL_FORMAT_SYMBOLS_PROVIDED) == null) {
            this.javascriptSupport.addScript(InitializationPriority.IMMEDIATE, "Tapestry.decimalFormatSymbols = %s;", this.createJSONDecimalFormatSymbols().toString(this.compactJSON));
            this.request.setAttribute(DECIMAL_FORMAT_SYMBOLS_PROVIDED, true);
        }
        this.clientBehaviorSupport.addValidation(field, "numericformat", message, this.isIntegerType(type));
    }

    private JSONObject createJSONDecimalFormatSymbols() {
        Locale locale = this.threadLocale.getLocale();
        DecimalFormatSymbols symbols = this.getSymbols(locale);
        JSONObject result = new JSONObject();
        result.put("groupingSeparator", (Object)NumericTranslatorSupportImpl.toString(symbols.getGroupingSeparator()));
        result.put("minusSign", (Object)NumericTranslatorSupportImpl.toString(symbols.getMinusSign()));
        result.put("decimalSeparator", (Object)NumericTranslatorSupportImpl.toString(symbols.getDecimalSeparator()));
        return result;
    }

    private DecimalFormatSymbols getSymbols(Locale locale) {
        DecimalFormatSymbols symbols = this.symbolsCache.get(locale);
        if (symbols == null) {
            symbols = new DecimalFormatSymbols(locale);
            this.symbolsCache.put(locale, symbols);
        }
        return symbols;
    }

    private boolean isIntegerType(Class type) {
        return this.integerTypes.contains(type);
    }

    @Override
    public <T extends Number> T parseClient(Class<T> type, String clientValue) throws ParseException {
        NumericFormatter formatter = this.getParseFormatter(type);
        Number number = formatter.parse(clientValue.trim());
        return (T)((Number)this.typeCoercer.coerce((Object)number, type));
    }

    private NumericFormatter getParseFormatter(Class type) {
        Locale locale = this.threadLocale.getLocale();
        DecimalFormatSymbols symbols = this.getSymbols(locale);
        if (type.equals(BigInteger.class)) {
            return new BigIntegerNumericFormatter(symbols);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimalNumericFormatter(symbols);
        }
        if (this.isIntegerType(type)) {
            NumberFormat format = NumberFormat.getIntegerInstance(locale);
            return new NumericFormatterImpl(format);
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        if (type.equals(BigDecimal.class)) {
            df.setParseBigDecimal(true);
        }
        return new NumericFormatterImpl(df);
    }

    private NumericFormatter getOutputFormatter(Class type) {
        Locale locale = this.threadLocale.getLocale();
        DecimalFormatSymbols symbols = this.getSymbols(locale);
        if (type.equals(BigInteger.class)) {
            return new BigIntegerNumericFormatter(symbols);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimalNumericFormatter(symbols);
        }
        if (!this.isIntegerType(type)) {
            NumberFormat format = NumberFormat.getNumberInstance(locale);
            return new NumericFormatterImpl(format);
        }
        DecimalFormat df = new DecimalFormat(NumericTranslatorSupportImpl.toString(symbols.getZeroDigit()), symbols);
        return new NumericFormatterImpl(df);
    }

    @Override
    public <T extends Number> String toClient(Class<T> type, T value) {
        return this.getOutputFormatter(type).toClient(value);
    }

    @Override
    public <T extends Number> String getMessageKey(Class<T> type) {
        return this.isIntegerType(type) ? "integer-format-exception" : "number-format-exception";
    }

    private static String toString(char ch) {
        return String.valueOf(ch);
    }
}

