/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.translator;

import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import org.apache.tapestry5.internal.translator.NumericFormatter;

public abstract class BigTypesFormatter
implements NumericFormatter {
    protected final DecimalFormatSymbols symbols;

    public BigTypesFormatter(DecimalFormatSymbols symbols) {
        this.symbols = symbols;
    }

    protected String toString(char ch) {
        return String.valueOf(ch);
    }

    public String toClient(Number value) {
        String normal = value.toString();
        return normal.replace('-', this.symbols.getMinusSign()).replace('.', this.symbols.getDecimalSeparator());
    }

    public Number parse(String clientValue) throws ParseException {
        String noGroups = clientValue.replace(this.toString(this.symbols.getGroupingSeparator()), "").replace(" ", "");
        String fixedNeg = noGroups.replace(this.symbols.getMinusSign(), '-');
        String fixedDec = fixedNeg.replace(this.symbols.getDecimalSeparator(), '.');
        try {
            return this.parseConvertedValue(fixedDec);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    protected abstract Number parseConvertedValue(String var1);
}

