/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.Collection;
import org.apache.tapestry5.annotations.PageReset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.structure.PageResetListener;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ConstructorCallback;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodHandle;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageResetAnnotationWorker
implements ComponentClassTransformWorker2 {
    private static final String META_KEY = "tapestry.page-reset-listener";
    private final ConstructorCallback REGISTER_AS_LISTENER = new ConstructorCallback(){

        public void onConstruct(Object instance, InstanceContext context) {
            InternalComponentResources resources = (InternalComponentResources)context.get(InternalComponentResources.class);
            resources.addPageResetListener((PageResetListener)instance);
        }
    };
    private final Predicate<PlasticMethod> METHOD_MATCHER = new Predicate<PlasticMethod>(){

        public boolean accept(PlasticMethod method) {
            return method.getDescription().methodName.equalsIgnoreCase("pageReset") || method.hasAnnotation(PageReset.class);
        }
    };
    private final Worker<PlasticMethod> METHOD_VALIDATOR = new Worker<PlasticMethod>(){

        public void work(PlasticMethod method) {
            boolean valid;
            boolean bl = valid = method.isVoid() && method.getParameters().isEmpty();
            if (!valid) {
                throw new RuntimeException(String.format("Method %s is invalid: methods with the @PageReset annotation must return void, and have no parameters.", method.getMethodIdentifier()));
            }
        }
    };
    private final Mapper<PlasticMethod, MethodHandle> TO_HANDLE = new Mapper<PlasticMethod, MethodHandle>(){

        public MethodHandle map(PlasticMethod method) {
            return method.getHandle();
        }
    };

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        Flow<PlasticMethod> methods = this.findResetMethods(plasticClass);
        if (!methods.isEmpty()) {
            if (!plasticClass.isInterfaceImplemented(PageResetListener.class)) {
                plasticClass.introduceInterface(PageResetListener.class);
                plasticClass.onConstruct(this.REGISTER_AS_LISTENER);
            }
            this.invokeMethodsOnPageReset(plasticClass, methods);
        }
    }

    private void invokeMethodsOnPageReset(PlasticClass plasticClass, Flow<PlasticMethod> methods) {
        final MethodHandle[] handles = (MethodHandle[])methods.map(this.TO_HANDLE).toArray(MethodHandle.class);
        plasticClass.introduceMethod(TransformConstants.CONTAINING_PAGE_DID_RESET_DESCRIPTION).addAdvice(new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                invocation.proceed();
                Object instance = invocation.getInstance();
                for (MethodHandle handle : handles) {
                    handle.invoke(instance, new Object[0]);
                }
            }
        });
    }

    private Flow<PlasticMethod> findResetMethods(PlasticClass plasticClass) {
        return (Flow)((Flow)F.flow((Collection)plasticClass.getMethods()).filter(this.METHOD_MATCHER)).each(this.METHOD_VALIDATOR);
    }
}

