/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportWorker
implements ComponentClassTransformWorker2 {
    private final JavaScriptSupport javascriptSupport;
    private final SymbolSource symbolSource;
    private final AssetSource assetSource;
    private final Worker<Asset> importLibrary = new Worker<Asset>(){

        public void work(Asset asset) {
            ImportWorker.this.javascriptSupport.importJavaScriptLibrary(asset);
        }
    };
    private final Worker<Asset> importStylesheet = new Worker<Asset>(){

        public void work(Asset asset) {
            ImportWorker.this.javascriptSupport.importStylesheet(asset);
        }
    };
    private final Mapper<String, String> expandSymbols = new Mapper<String, String>(){

        public String map(String element) {
            return ImportWorker.this.symbolSource.expandSymbols(element);
        }
    };

    public ImportWorker(JavaScriptSupport javascriptSupport, SymbolSource symbolSource, AssetSource assetSource) {
        this.javascriptSupport = javascriptSupport;
        this.symbolSource = symbolSource;
        this.assetSource = assetSource;
    }

    @Override
    public void transform(PlasticClass componentClass, TransformationSupport support, MutableComponentModel model) {
        this.processClassAnnotationAtSetupRenderPhase(componentClass, model);
        for (PlasticMethod m : componentClass.getMethodsWithAnnotation(Import.class)) {
            this.decorateMethod(componentClass, model, m);
        }
    }

    private void processClassAnnotationAtSetupRenderPhase(PlasticClass componentClass, MutableComponentModel model) {
        Import annotation = (Import)componentClass.getAnnotation(Import.class);
        if (annotation != null) {
            PlasticMethod setupRender = componentClass.introduceMethod(TransformConstants.SETUP_RENDER_DESCRIPTION);
            this.decorateMethod(componentClass, model, setupRender, annotation);
            model.addRenderPhase(SetupRender.class);
        }
    }

    private void decorateMethod(PlasticClass componentClass, MutableComponentModel model, PlasticMethod method) {
        Import annotation = (Import)method.getAnnotation(Import.class);
        this.decorateMethod(componentClass, model, method, annotation);
    }

    private void decorateMethod(PlasticClass componentClass, MutableComponentModel model, PlasticMethod method, Import annotation) {
        this.importStacks(method, annotation.stack());
        this.importLibraries(componentClass, model, method, annotation.library());
        this.importStylesheets(componentClass, model, method, annotation.stylesheet());
    }

    private void importStacks(PlasticMethod method, String[] stacks) {
        if (stacks.length != 0) {
            method.addAdvice(this.createImportStackAdvice(stacks));
        }
    }

    private MethodAdvice createImportStackAdvice(final String[] stacks) {
        return new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                for (String stack : stacks) {
                    ImportWorker.this.javascriptSupport.importStack(stack);
                }
                invocation.proceed();
            }
        };
    }

    private void importLibraries(PlasticClass plasticClass, MutableComponentModel model, PlasticMethod method, String[] paths) {
        this.decorateMethodWithOperation(plasticClass, model, method, paths, this.importLibrary);
    }

    private void importStylesheets(PlasticClass plasticClass, MutableComponentModel model, PlasticMethod method, String[] paths) {
        this.decorateMethodWithOperation(plasticClass, model, method, paths, this.importStylesheet);
    }

    private void decorateMethodWithOperation(PlasticClass componentClass, MutableComponentModel model, PlasticMethod method, String[] paths, Worker<Asset> operation) {
        if (paths.length == 0) {
            return;
        }
        String[] expandedPaths = this.expandPaths(paths);
        PlasticField assetListField = componentClass.introduceField(Asset[].class, "importedAssets_" + method.getDescription().methodName);
        this.initializeAssetsFromPaths(model.getBaseResource(), expandedPaths, assetListField);
        this.addMethodAssetOperationAdvice(method, assetListField.getHandle(), operation);
    }

    private String[] expandPaths(String[] paths) {
        return (String[])F.flow((Object[])paths).map(this.expandSymbols).toArray(String.class);
    }

    private void initializeAssetsFromPaths(final Resource baseResource, final String[] expandedPaths, PlasticField assetsField) {
        assetsField.injectComputed((ComputedValue)new ComputedValue<Asset[]>(){

            public Asset[] get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                return ImportWorker.this.convertPathsToAssetArray(baseResource, resources.getLocale(), expandedPaths);
            }
        });
    }

    private Asset[] convertPathsToAssetArray(final Resource baseResource, final Locale locale, String[] assetPaths) {
        return (Asset[])F.flow((Object[])assetPaths).map((Mapper)new Mapper<String, Asset>(){

            public Asset map(String assetPath) {
                return ImportWorker.this.assetSource.getAsset(baseResource, assetPath, locale);
            }
        }).toArray(Asset.class);
    }

    private void addMethodAssetOperationAdvice(PlasticMethod method, final FieldHandle access, final Worker<Asset> operation) {
        method.addAdvice(new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                Object[] assets = (Asset[])access.get(invocation.getInstance());
                F.flow((Object[])assets).each(operation);
                invocation.proceed();
            }
        });
    }
}

