/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class EnvironmentalWorker
implements ComponentClassTransformWorker2 {
    private final Environment environment;
    private final ComponentClassCache classCache;

    public EnvironmentalWorker(Environment environment, ComponentClassCache classCache) {
        this.environment = environment;
        this.classCache = classCache;
    }

    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(Environmental.class)) {
            this.transform(model.getComponentClassName(), field);
        }
    }

    private void transform(final String componentClassName, PlasticField field) {
        Environmental annotation = (Environmental)field.getAnnotation(Environmental.class);
        field.claim((Object)annotation);
        final String fieldName = field.getName();
        final Class fieldType = this.classCache.forName(field.getTypeName());
        final boolean required = annotation.value();
        ComputedValue<FieldConduit<Object>> provider = new ComputedValue<FieldConduit<Object>>(){

            public FieldConduit<Object> get(InstanceContext context) {
                return new EnvironmentalConduit(componentClassName, fieldName, fieldType, required);
            }

            public void set(Object instance, InstanceContext context, Object newValue) {
                throw new RuntimeException(String.format("Field %s of component %s is read only.", fieldName, componentClassName));
            }
        };
        field.setComputedConduit((ComputedValue)provider);
    }

    private final class EnvironmentalConduit
    implements FieldConduit {
        private final String componentClassName;
        private final String fieldName;
        private final Class environmentalType;
        private final boolean required;

        private EnvironmentalConduit(String componentClassName, String fieldName, Class environmentalType, boolean required) {
            this.componentClassName = componentClassName;
            this.fieldName = fieldName;
            this.environmentalType = environmentalType;
            this.required = required;
        }

        public Object get(Object instance, InstanceContext context) {
            return this.required ? EnvironmentalWorker.this.environment.peekRequired(this.environmentalType) : EnvironmentalWorker.this.environment.peek(this.environmentalType);
        }

        public void set(Object instance, InstanceContext context, Object newValue) {
            throw new RuntimeException(String.format("Field %s.%s is read only.", this.componentClassName, this.fieldName));
        }
    }
}

