/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.DiscardAfter;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class DiscardAfterWorker
implements ComponentClassTransformWorker2 {
    private static final MethodAdvice advice = new MethodAdvice(){

        public void advise(MethodInvocation invocation) {
            invocation.proceed();
            if (invocation.didThrowCheckedException()) {
                return;
            }
            ComponentResources resources = (ComponentResources)invocation.getInstanceContext().get(ComponentResources.class);
            resources.discardPersistentFieldChanges();
        }
    };

    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticMethod method : plasticClass.getMethodsWithAnnotation(DiscardAfter.class)) {
            method.addAdvice(advice);
        }
    }
}

