/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.internal.test.TestableResponse;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

public class TestableResponseImpl
implements TestableResponse {
    private Link link;
    private boolean committed;
    private Document renderedDocument;
    private Map<String, Object> headers;
    private String redirectURL;
    private int status = 200;
    private String errorMessage;
    private int contentLength = 0;
    private String contentType;
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ServletOutputStream outputStream = new TesableServletOutputStream(this.output);
    private PrintWriter printWriter;

    public TestableResponseImpl() {
        this.headers = CollectionFactory.newMap();
    }

    public OutputStream getOutputStream(String contentType) throws IOException {
        this.contentType = contentType;
        return this.outputStream;
    }

    public PrintWriter getPrintWriter(String contentType) throws IOException {
        this.committed = true;
        this.contentType = contentType;
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new OutputStreamWriter(this.output));
        }
        return this.printWriter;
    }

    public void sendError(int sc, String message) throws IOException {
        this.setCommitted();
        this.status = sc;
        this.errorMessage = message;
    }

    public void sendRedirect(String URL2) throws IOException {
        this.setCommitted();
        this.redirectURL = URL2;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setDateHeader(String name, long date) {
        this.headers.put(name, date);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, value);
    }

    public void sendRedirect(Link link) throws IOException {
        this.setCommitted();
        this.link = link;
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public String encodeRedirectURL(String URL2) {
        return URL2;
    }

    public String encodeURL(String URL2) {
        return URL2;
    }

    public Link getRedirectLink() {
        return this.link;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void clear() {
        this.committed = false;
        this.link = null;
        this.renderedDocument = null;
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
        this.contentLength = 0;
        this.contentType = null;
        this.output.reset();
    }

    public Document getRenderedDocument() {
        return this.renderedDocument;
    }

    public void setRenderedDocument(Document document) {
        this.renderedDocument = document;
    }

    public void disableCompression() {
    }

    public Object getHeader(String name) {
        return this.headers.get(name);
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    private void setCommitted() {
        this.committed = true;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getOutput() {
        return this.output.toString();
    }

    private class TesableServletOutputStream
    extends ServletOutputStream {
        private OutputStream delegate;

        public TesableServletOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void flush() throws IOException {
            super.flush();
            this.delegate.flush();
            TestableResponseImpl.this.setCommitted();
        }

        public void close() throws IOException {
            super.close();
            this.delegate.close();
        }
    }
}

