/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.templates;

import java.util.Locale;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.templates.ComponentTemplateLocator;

public class PageTemplateLocator
implements ComponentTemplateLocator {
    private final Resource contextRoot;
    private final ComponentClassResolver resolver;
    private final String prefix;

    public PageTemplateLocator(Resource contextRoot, ComponentClassResolver resolver, String applicationFolder) {
        this.contextRoot = contextRoot;
        this.resolver = resolver;
        this.prefix = applicationFolder.equals("") ? "" : applicationFolder + "/";
    }

    public Resource locateTemplate(ComponentModel model, Locale locale) {
        if (!model.isPage()) {
            return null;
        }
        String className = model.getComponentClassName();
        String logicalName = this.resolver.resolvePageClassNameToPageName(className);
        int slashx = logicalName.lastIndexOf(47);
        if (slashx > 0) {
            String simpleClassName = InternalUtils.lastTerm((String)className);
            logicalName = logicalName.substring(0, slashx + 1) + simpleClassName;
        }
        String path = this.prefix + logicalName + "." + "tml";
        return this.contextRoot.forFile(path).forLocale(locale);
    }
}

