/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StylesheetLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFieldStack
implements JavaScriptStack {
    private final ThreadLocale threadLocale;
    private final boolean compactJSON;
    private final List<Asset> javaScriptStack;
    private final List<StylesheetLink> stylesheetStack;

    public DateFieldStack(ThreadLocale threadLocale, @Symbol(value="tapestry.compact-json") boolean compactJSON, final AssetSource assetSource) {
        this.threadLocale = threadLocale;
        this.compactJSON = compactJSON;
        Mapper<String, Asset> pathToAsset = new Mapper<String, Asset>(){

            public Asset map(String path) {
                return assetSource.getExpandedAsset(path);
            }
        };
        Mapper pathToStylesheetLink = F.combine((Mapper)pathToAsset, TapestryInternalUtils.assetToStylesheetLink);
        this.javaScriptStack = F.flow((Object[])new String[]{"${tapestry.datepicker}/js/datepicker.js", "org/apache/tapestry5/corelib/components/datefield.js"}).map((Mapper)pathToAsset).toList();
        this.stylesheetStack = F.flow((Object[])new String[]{"${tapestry.datepicker}/css/datepicker.css"}).map(pathToStylesheetLink).toList();
    }

    @Override
    public String getInitialization() {
        Locale locale = this.threadLocale.getLocale();
        JSONObject spec = new JSONObject();
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        spec.put("months", (Object)new JSONArray((Object[])symbols.getMonths()));
        StringBuilder days = new StringBuilder();
        String[] weekdays = symbols.getWeekdays();
        Calendar c = Calendar.getInstance(locale);
        int firstDay = c.getFirstDayOfWeek();
        for (int i = 2; i <= 7; ++i) {
            days.append(weekdays[i].substring(0, 1));
        }
        days.append(weekdays[1].substring(0, 1));
        spec.put("days", (Object)days.toString().toLowerCase(locale));
        spec.put("firstDay", (Object)(firstDay == 1 ? 6 : firstDay - 2));
        return String.format("Tapestry.DateField.initLocalization(%s);", spec.toString(this.compactJSON));
    }

    @Override
    public List<Asset> getJavaScriptLibraries() {
        return this.javaScriptStack;
    }

    @Override
    public List<StylesheetLink> getStylesheets() {
        return this.stylesheetStack;
    }

    @Override
    public List<String> getStacks() {
        return Collections.emptyList();
    }
}

