/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.util.Map;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.assets.ContentTypeAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypeAnalyzerImpl
implements ContentTypeAnalyzer {
    private final Context context;
    private final Map<String, String> configuration;

    public ContentTypeAnalyzerImpl(Context context, Map<String, String> configuration) {
        this.context = context;
        this.configuration = configuration;
    }

    @Override
    public String getContentType(Resource resource) {
        String extension = TapestryInternalUtils.toFileSuffix(resource.getFile());
        String contentType = this.configuration.get(extension);
        if (contentType != null) {
            return contentType;
        }
        contentType = this.context.getMimeType(resource.getFile());
        if (contentType != null) {
            return contentType;
        }
        return "application/octet-stream";
    }
}

