/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.ajax;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldFocusPriority;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.internal.services.javascript.JavaScriptStackPathConstructor;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.javascript.StylesheetLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptSupportImpl
implements JavaScriptSupport {
    private final IdAllocator idAllocator;
    private final DocumentLinker linker;
    private final Map<String, Boolean> addedStacks = CollectionFactory.newCaseInsensitiveMap();
    private final List<String> stackLibraries = CollectionFactory.newList();
    private final List<String> otherLibraries = CollectionFactory.newList();
    private final Set<String> importedStylesheetURLs = CollectionFactory.newSet();
    private final List<StylesheetLink> stylesheetLinks = CollectionFactory.newList();
    private final Map<InitializationPriority, JSONObject> inits = CollectionFactory.newMap();
    private final JavaScriptStackSource javascriptStackSource;
    private final JavaScriptStackPathConstructor stackPathConstructor;
    private final boolean partialMode;
    private FieldFocusPriority focusPriority;
    private String focusFieldId;
    private Map<String, String> libraryURLToStackName;

    public JavaScriptSupportImpl(DocumentLinker linker, JavaScriptStackSource javascriptStackSource, JavaScriptStackPathConstructor stackPathConstructor) {
        this(linker, javascriptStackSource, stackPathConstructor, new IdAllocator(), false);
    }

    public JavaScriptSupportImpl(DocumentLinker linker, JavaScriptStackSource javascriptStackSource, JavaScriptStackPathConstructor stackPathConstructor, IdAllocator idAllocator, boolean partialMode) {
        this.linker = linker;
        this.idAllocator = idAllocator;
        this.javascriptStackSource = javascriptStackSource;
        this.stackPathConstructor = stackPathConstructor;
        this.partialMode = partialMode;
        if (partialMode) {
            this.addedStacks.put("core", true);
        }
    }

    public void commit() {
        if (this.focusFieldId != null) {
            this.addInitializerCall("activate", this.focusFieldId);
        }
        F.flow(this.stylesheetLinks).each((Worker)new Worker<StylesheetLink>(){

            public void work(StylesheetLink value) {
                JavaScriptSupportImpl.this.linker.addStylesheetLink(value);
            }
        });
        Worker<String> linkLibrary = new Worker<String>(){

            public void work(String value) {
                JavaScriptSupportImpl.this.linker.addScriptLink(value);
            }
        };
        F.flow(this.stackLibraries).each((Worker)linkLibrary);
        F.flow(this.otherLibraries).each((Worker)linkLibrary);
        for (InitializationPriority p : InitializationPriority.values()) {
            JSONObject init = this.inits.get((Object)p);
            if (init == null) continue;
            this.linker.setInitialization(p, init);
        }
    }

    @Override
    public void addInitializerCall(InitializationPriority priority, String functionName, JSONObject parameter) {
        this.storeInitializerCall(priority, functionName, parameter);
    }

    @Override
    public void addInitializerCall(String functionName, JSONArray parameter) {
        this.storeInitializerCall(InitializationPriority.NORMAL, functionName, parameter);
    }

    @Override
    public void addInitializerCall(InitializationPriority priority, String functionName, JSONArray parameter) {
        this.storeInitializerCall(priority, functionName, parameter);
    }

    private void storeInitializerCall(InitializationPriority priority, String functionName, Object parameter) {
        JSONArray invocations;
        assert (priority != null);
        assert (parameter != null);
        assert (InternalUtils.isNonBlank((String)functionName));
        this.addCoreStackIfNeeded();
        JSONObject init = this.inits.get((Object)priority);
        if (init == null) {
            init = new JSONObject();
            this.inits.put(priority, init);
        }
        JSONArray jSONArray = invocations = init.has(functionName) ? init.getJSONArray(functionName) : null;
        if (invocations == null) {
            invocations = new JSONArray();
            init.put(functionName, (Object)invocations);
        }
        invocations.put(parameter);
    }

    @Override
    public void addInitializerCall(String functionName, JSONObject parameter) {
        this.addInitializerCall(InitializationPriority.NORMAL, functionName, parameter);
    }

    @Override
    public void addInitializerCall(InitializationPriority priority, String functionName, String parameter) {
        this.storeInitializerCall(priority, functionName, parameter);
    }

    @Override
    public void addInitializerCall(String functionName, String parameter) {
        this.addInitializerCall(InitializationPriority.NORMAL, functionName, parameter);
    }

    @Override
    public void addScript(InitializationPriority priority, String format, Object ... arguments) {
        String newScript;
        assert (priority != null);
        assert (InternalUtils.isNonBlank((String)format));
        this.addCoreStackIfNeeded();
        String string = newScript = arguments.length == 0 ? format : String.format(format, arguments);
        if (this.partialMode) {
            this.addInitializerCall(priority, "evalScript", newScript);
        } else {
            this.linker.addScript(priority, newScript);
        }
    }

    @Override
    public void addScript(String format, Object ... arguments) {
        this.addScript(InitializationPriority.NORMAL, format, arguments);
    }

    @Override
    public String allocateClientId(ComponentResources resources) {
        return this.allocateClientId(resources.getId());
    }

    @Override
    public String allocateClientId(String id) {
        return this.idAllocator.allocateId(id);
    }

    @Override
    public void importJavaScriptLibrary(Asset asset) {
        assert (asset != null);
        this.importJavaScriptLibrary(asset.toClientURL());
    }

    @Override
    public void importJavaScriptLibrary(String libraryURL) {
        this.addCoreStackIfNeeded();
        String stackName = this.findStackForLibrary(libraryURL);
        if (stackName != null) {
            this.importStack(stackName);
            return;
        }
        if (this.otherLibraries.contains(libraryURL)) {
            return;
        }
        this.otherLibraries.add(libraryURL);
    }

    private String findStackForLibrary(String libraryURL) {
        return this.getLibraryURLToStackName().get(libraryURL);
    }

    private Map<String, String> getLibraryURLToStackName() {
        if (this.libraryURLToStackName == null) {
            this.libraryURLToStackName = CollectionFactory.newMap();
            for (String stackName : this.javascriptStackSource.getStackNames()) {
                for (Asset library : this.javascriptStackSource.getStack(stackName).getJavaScriptLibraries()) {
                    this.libraryURLToStackName.put(library.toClientURL(), stackName);
                }
            }
        }
        return this.libraryURLToStackName;
    }

    private void addCoreStackIfNeeded() {
        this.addAssetsFromStack("core");
    }

    private void addAssetsFromStack(String stackName) {
        if (this.addedStacks.containsKey(stackName)) {
            return;
        }
        JavaScriptStack stack = this.javascriptStackSource.getStack(stackName);
        for (String dependentStackname : stack.getStacks()) {
            this.addAssetsFromStack(dependentStackname);
        }
        this.stackLibraries.addAll(this.stackPathConstructor.constructPathsForJavaScriptStack(stackName));
        this.stylesheetLinks.addAll(stack.getStylesheets());
        this.addedStacks.put(stackName, true);
        String initialization = stack.getInitialization();
        if (initialization != null) {
            this.addScript(InitializationPriority.IMMEDIATE, initialization, new Object[0]);
        }
    }

    @Override
    public void importStylesheet(Asset stylesheet) {
        assert (stylesheet != null);
        this.importStylesheet(new StylesheetLink(stylesheet));
    }

    @Override
    public void importStylesheet(StylesheetLink stylesheetLink) {
        assert (stylesheetLink != null);
        String stylesheetURL = stylesheetLink.getURL();
        if (this.importedStylesheetURLs.contains(stylesheetURL)) {
            return;
        }
        this.importedStylesheetURLs.add(stylesheetURL);
        this.stylesheetLinks.add(stylesheetLink);
    }

    @Override
    public void importStack(String stackName) {
        assert (InternalUtils.isNonBlank((String)stackName));
        this.addCoreStackIfNeeded();
        this.addAssetsFromStack(stackName);
    }

    @Override
    public void autofocus(FieldFocusPriority priority, String fieldId) {
        assert (priority != null);
        assert (InternalUtils.isNonBlank((String)fieldId));
        if (this.focusFieldId == null || priority.compareTo(this.focusPriority) > 0) {
            this.focusPriority = priority;
            this.focusFieldId = fieldId;
        }
    }
}

