/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tapestry5.internal.IOOperation;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

public class ResourceStreamerImpl
implements ResourceStreamer {
    static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    private final Request request;
    private final Response response;
    private final StreamableResourceSource streamableResourceSource;
    private final ResponseCompressionAnalyzer analyzer;
    private final boolean productionMode;
    private final OperationTracker tracker;
    private final ResourceChangeTracker resourceChangeTracker;

    public ResourceStreamerImpl(Request request, Response response, StreamableResourceSource streamableResourceSource, ResponseCompressionAnalyzer analyzer, OperationTracker tracker, @Symbol(value="tapestry.production-mode") boolean productionMode, ResourceChangeTracker resourceChangeTracker) {
        this.request = request;
        this.response = response;
        this.streamableResourceSource = streamableResourceSource;
        this.analyzer = analyzer;
        this.tracker = tracker;
        this.productionMode = productionMode;
        this.resourceChangeTracker = resourceChangeTracker;
    }

    public void streamResource(final Resource resource) throws IOException {
        if (!resource.exists()) {
            this.response.sendError(404, ServicesMessages.assetDoesNotExist(resource));
            return;
        }
        TapestryInternalUtils.performIO(this.tracker, String.format("Streaming %s", resource), new IOOperation(){

            public void perform() throws IOException {
                StreamableResourceProcessing processing = ResourceStreamerImpl.this.analyzer.isGZipSupported() ? StreamableResourceProcessing.COMPRESSION_ENABLED : StreamableResourceProcessing.COMPRESSION_DISABLED;
                StreamableResource streamable = ResourceStreamerImpl.this.streamableResourceSource.getStreamableResource(resource, processing, ResourceStreamerImpl.this.resourceChangeTracker);
                ResourceStreamerImpl.this.streamResource(streamable);
            }
        });
    }

    public void streamResource(StreamableResource streamable) throws IOException {
        long lastModified = streamable.getLastModified();
        long ifModifiedSince = 0L;
        try {
            ifModifiedSince = this.request.getDateHeader(IF_MODIFIED_SINCE_HEADER);
        }
        catch (IllegalArgumentException ex) {
            ifModifiedSince = -1L;
        }
        if (ifModifiedSince > 0L && ifModifiedSince >= lastModified) {
            this.response.setStatus(304);
            return;
        }
        this.response.disableCompression();
        this.response.setDateHeader("Last-Modified", lastModified);
        if (this.productionMode) {
            this.response.setDateHeader("Expires", lastModified + InternalConstants.TEN_YEARS);
        }
        this.response.setContentLength(streamable.getSize());
        if (streamable.getCompression() == CompressionStatus.COMPRESSED) {
            this.response.setHeader("Content-Encoding", "gzip");
        }
        OutputStream os = this.response.getOutputStream(streamable.getContentType());
        streamable.streamTo(os);
        os.close();
    }
}

