/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.TapestryMarkers;
import org.apache.tapestry5.internal.services.RenderQueueException;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.Stack;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.slf4j.Logger;

public class RenderQueueImpl
implements RenderQueue {
    private static final int INITIAL_QUEUE_DEPTH = 200;
    private final Stack<RenderCommand> queue = CollectionFactory.newStack((int)200);
    private final Stack<ComponentResources> renderingComponents = CollectionFactory.newStack();
    private final Logger logger;

    public RenderQueueImpl(Logger logger) {
        this.logger = logger;
    }

    public void push(RenderCommand command) {
        assert (command != null);
        this.queue.push((Object)command);
    }

    public void run(MarkupWriter writer) {
        RenderCommand command = null;
        boolean traceEnabled = this.logger.isTraceEnabled(TapestryMarkers.RENDER_COMMANDS);
        long startNanos = System.nanoTime();
        int commandCount = 0;
        int maxDepth = 0;
        try {
            while (!this.queue.isEmpty()) {
                maxDepth = Math.max(maxDepth, this.queue.getDepth());
                command = (RenderCommand)this.queue.pop();
                ++commandCount;
                if (traceEnabled) {
                    this.logger.trace(TapestryMarkers.RENDER_COMMANDS, "Executing: {}", (Object)command);
                }
                command.render(writer, this);
            }
        }
        catch (RuntimeException ex) {
            String message = ServicesMessages.renderQueueError(command, ex);
            this.logger.error(message, (Throwable)ex);
            throw new RenderQueueException(message, this.renderingComponents.getSnapshot(), ex);
        }
        long endNanos = System.nanoTime();
        long elapsedNanos = endNanos - startNanos;
        double elapsedSeconds = (double)elapsedNanos / 1.0E9;
        this.logger.debug(TapestryMarkers.RENDER_COMMANDS, String.format("Executed %,d rendering commands (max queue depth: %,d) in %.3f seconds", commandCount, maxDepth, elapsedSeconds));
    }

    public void startComponent(ComponentResources resources) {
        assert (resources != null);
        this.renderingComponents.push((Object)resources);
    }

    public void endComponent() {
        this.renderingComponents.pop();
    }
}

