/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.internal.services.PersistentFieldBundleImpl;
import org.apache.tapestry5.internal.services.PersistentFieldManager;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.MetaDataLocator;
import org.apache.tapestry5.services.PersistentFieldBundle;
import org.apache.tapestry5.services.PersistentFieldStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentFieldManagerImpl
implements PersistentFieldManager {
    private final MetaDataLocator metaDataLocator;
    private final Map<String, PersistentFieldStrategy> strategies;

    public PersistentFieldManagerImpl(MetaDataLocator locator, Map<String, PersistentFieldStrategy> strategies) {
        this.metaDataLocator = locator;
        this.strategies = strategies;
    }

    private PersistentFieldStrategy getStrategy(String strategyName) {
        PersistentFieldStrategy result = this.strategies.get(strategyName);
        if (result == null) {
            throw new UnknownValueException(String.format("'%s' is not a defined persistent strategy.", strategyName), new AvailableValues("Configured persistent field strategies", this.strategies));
        }
        return result;
    }

    @Override
    public PersistentFieldBundle gatherChanges(String pageName) {
        List allChanges = CollectionFactory.newList();
        for (PersistentFieldStrategy strategy : this.strategies.values()) {
            allChanges.addAll(strategy.gatherFieldChanges(pageName));
        }
        return new PersistentFieldBundleImpl(allChanges);
    }

    @Override
    public void discardChanges(String pageName) {
        for (PersistentFieldStrategy strategy : this.strategies.values()) {
            strategy.discardChanges(pageName);
        }
    }

    @Override
    public void discardChanges(String pageName, String strategyName) {
        PersistentFieldStrategy strategy = this.strategies.get(strategyName);
        if (strategy != null) {
            strategy.discardChanges(pageName);
        }
    }

    @Override
    public void postChange(String pageName, ComponentResources resources, String fieldName, Object newValue) {
        String strategyName = this.findStrategy(resources, fieldName);
        PersistentFieldStrategy strategy = this.getStrategy(strategyName);
        strategy.postChange(pageName, resources.getNestedId(), fieldName, newValue);
    }

    private String findStrategy(ComponentResources resources, String fieldName) {
        ComponentModel model = resources.getComponentModel();
        String strategy = model.getFieldPersistenceStrategy(fieldName);
        if (InternalUtils.isNonBlank((String)strategy)) {
            return strategy;
        }
        return this.metaDataLocator.findMeta("tapestry.persistence-strategy", resources, String.class);
    }
}

