/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.services.ComponentEventResultProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectComponentEventResultProcessor
implements ComponentEventResultProcessor<Object> {
    private final Collection<Class> configuredClasses;

    public ObjectComponentEventResultProcessor(Collection<Class> configuredClasses) {
        this.configuredClasses = configuredClasses;
    }

    @Override
    public void processResultValue(Object value) throws IOException {
        List names = F.flow(this.configuredClasses).map((Mapper)new Mapper<Class, String>(){

            public String map(Class input) {
                return ClassFabUtils.toJavaClassName((Class)input);
            }
        }).toList();
        String message = String.format("A component event handler method returned the value %s. Return type %s can not be handled.", value, ClassFabUtils.toJavaClassName(value.getClass()));
        throw new UnknownValueException(message, new AvailableValues("Configured return types", (Collection)names));
    }
}

