/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObjectEventResultProcessor
implements ComponentEventResultProcessor<JSONObject> {
    private final Response response;
    private final String outputEncoding;
    private final boolean compactJSON;

    public JSONObjectEventResultProcessor(Response response, @Symbol(value="tapestry.charset") String outputEncoding, @Symbol(value="tapestry.compact-json") boolean compactJSON) {
        this.response = response;
        this.outputEncoding = outputEncoding;
        this.compactJSON = compactJSON;
    }

    @Override
    public void processResultValue(JSONObject value) throws IOException {
        ContentType contentType = new ContentType("application/json", this.outputEncoding);
        PrintWriter pw = this.response.getPrintWriter(contentType.toString());
        value.print(pw, this.compactJSON);
        pw.close();
    }
}

