/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.Validator;
import org.apache.tapestry5.internal.services.CompositeFieldValidator;
import org.apache.tapestry5.internal.services.FieldValidatorImpl;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.services.ValidatorSpecification;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.FieldValidatorSource;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.validator.ValidatorMacro;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldValidatorSourceImpl
implements FieldValidatorSource {
    private final Messages globalMessages;
    private final Map<String, Validator> validators;
    private final TypeCoercer typeCoercer;
    private final FormSupport formSupport;
    private final ValidatorMacro validatorMacro;

    public FieldValidatorSourceImpl(Messages globalMessages, TypeCoercer typeCoercer, FormSupport formSupport, Map<String, Validator> validators, ValidatorMacro validatorMacro) {
        this.globalMessages = globalMessages;
        this.typeCoercer = typeCoercer;
        this.formSupport = formSupport;
        this.validators = validators;
        this.validatorMacro = validatorMacro;
    }

    @Override
    public FieldValidator createValidator(Field field, String validatorType, String constraintValue) {
        Component component = (Component)((Object)field);
        assert (InternalUtils.isNonBlank((String)validatorType));
        ComponentResources componentResources = component.getComponentResources();
        String overrideId = componentResources.getId();
        Messages overrideMessages = componentResources.getContainerMessages();
        return this.createValidator(field, validatorType, constraintValue, overrideId, overrideMessages, null);
    }

    @Override
    public FieldValidator createValidator(Field field, String validatorType, String constraintValue, String overrideId, Messages overrideMessages, Locale locale) {
        ValidatorSpecification originalSpec = new ValidatorSpecification(validatorType, constraintValue);
        List org = CollectionFactory.newList((Object[])new ValidatorSpecification[]{originalSpec});
        List<ValidatorSpecification> specs = this.expandMacros(org);
        List fieldValidators = CollectionFactory.newList();
        for (ValidatorSpecification spec : specs) {
            fieldValidators.add(this.createValidator(field, spec, overrideId, overrideMessages));
        }
        return new CompositeFieldValidator(fieldValidators);
    }

    private FieldValidator createValidator(Field field, ValidatorSpecification spec, String overrideId, Messages overrideMessages) {
        String validatorType = spec.getValidatorType();
        assert (InternalUtils.isNonBlank((String)validatorType));
        Validator validator = this.validators.get(validatorType);
        if (validator == null) {
            throw new IllegalArgumentException(ServicesMessages.unknownValidatorType(validatorType, InternalUtils.sortedKeys(this.validators)));
        }
        String formValidationid = this.formSupport.getFormValidationId();
        Object coercedConstraintValue = this.computeConstraintValue(validatorType, validator, spec.getConstraintValue(), formValidationid, overrideId, overrideMessages);
        MessageFormatter formatter = this.findMessageFormatter(formValidationid, overrideId, overrideMessages, validatorType, validator);
        return new FieldValidatorImpl(field, coercedConstraintValue, formatter, validator, this.formSupport);
    }

    private Object computeConstraintValue(String validatorType, Validator validator, String constraintValue, String formId, String overrideId, Messages overrideMessages) {
        Class constraintType = validator.getConstraintType();
        String constraintText = this.findConstraintValue(validatorType, constraintType, constraintValue, formId, overrideId, overrideMessages);
        if (constraintText == null) {
            return null;
        }
        return this.typeCoercer.coerce((Object)constraintText, constraintType);
    }

    private String findConstraintValue(String validatorType, Class constraintType, String constraintValue, String formValidationId, String overrideId, Messages overrideMessages) {
        if (constraintValue != null) {
            return constraintValue;
        }
        if (constraintType == null) {
            return null;
        }
        String perFormKey = formValidationId + "-" + overrideId + "-" + validatorType;
        if (overrideMessages.contains(perFormKey)) {
            return overrideMessages.get(perFormKey);
        }
        String generalKey = overrideId + "-" + validatorType;
        if (overrideMessages.contains(generalKey)) {
            return overrideMessages.get(generalKey);
        }
        throw new IllegalArgumentException(ServicesMessages.missingValidatorConstraint(validatorType, constraintType, perFormKey, generalKey));
    }

    private MessageFormatter findMessageFormatter(String formId, String overrideId, Messages overrideMessages, String validatorType, Validator validator) {
        String overrideKey = formId + "-" + overrideId + "-" + validatorType + "-message";
        if (overrideMessages.contains(overrideKey)) {
            return overrideMessages.getFormatter(overrideKey);
        }
        overrideKey = overrideId + "-" + validatorType + "-message";
        if (overrideMessages.contains(overrideKey)) {
            return overrideMessages.getFormatter(overrideKey);
        }
        String key = validator.getMessageKey();
        return this.globalMessages.getFormatter(key);
    }

    @Override
    public FieldValidator createValidators(Field field, String specification) {
        List<ValidatorSpecification> specs = this.toValidatorSpecifications(specification);
        List fieldValidators = CollectionFactory.newList();
        for (ValidatorSpecification spec : specs) {
            fieldValidators.add(this.createValidator(field, spec.getValidatorType(), spec.getConstraintValue()));
        }
        if (fieldValidators.size() == 1) {
            return (FieldValidator)fieldValidators.get(0);
        }
        return new CompositeFieldValidator(fieldValidators);
    }

    List<ValidatorSpecification> toValidatorSpecifications(String specification) {
        return this.expandMacros(FieldValidatorSourceImpl.parse(specification));
    }

    private List<ValidatorSpecification> expandMacros(List<ValidatorSpecification> specs) {
        Map expandedMacros = CollectionFactory.newCaseInsensitiveMap();
        List queue = CollectionFactory.newList(specs);
        List result = CollectionFactory.newList();
        while (!queue.isEmpty()) {
            ValidatorSpecification head = (ValidatorSpecification)queue.remove(0);
            String validatorType = head.getValidatorType();
            String expanded = this.validatorMacro.valueForMacro(validatorType);
            if (expanded != null) {
                if (head.getConstraintValue() != null) {
                    throw new RuntimeException(String.format("'%s' is a validator macro, not a validator, and can not have a constraint value.", validatorType));
                }
                if (expandedMacros.containsKey(validatorType)) {
                    throw new RuntimeException(String.format("Validator macro '%s' appears more than once.", validatorType));
                }
                expandedMacros.put(validatorType, true);
                List<ValidatorSpecification> parsed = FieldValidatorSourceImpl.parse(expanded);
                for (int i = 0; i < parsed.size(); ++i) {
                    queue.add(i, parsed.get(i));
                }
                continue;
            }
            result.add(head);
        }
        return result;
    }

    static List<ValidatorSpecification> parse(String specification) {
        List result = CollectionFactory.newList();
        char[] input = specification.toCharArray();
        int cursor = 0;
        int start = -1;
        String type = null;
        boolean skipWhitespace = true;
        State state = State.TYPE_START;
        block14: while (cursor < input.length) {
            char ch = input[cursor];
            if (skipWhitespace && Character.isWhitespace(ch)) {
                ++cursor;
                continue;
            }
            skipWhitespace = false;
            switch (state) {
                case TYPE_START: {
                    if (Character.isLetter(ch)) {
                        start = cursor;
                        state = State.TYPE_END;
                        break;
                    }
                    FieldValidatorSourceImpl.parseError(cursor, specification);
                }
                case TYPE_END: {
                    if (Character.isLetter(ch)) break;
                    type = specification.substring(start, cursor);
                    skipWhitespace = true;
                    state = State.EQUALS_OR_COMMA;
                    continue block14;
                }
                case EQUALS_OR_COMMA: {
                    if (ch == '=') {
                        skipWhitespace = true;
                        state = State.VALUE_START;
                        break;
                    }
                    if (ch == ',') {
                        result.add(new ValidatorSpecification(type));
                        type = null;
                        state = State.COMMA;
                        continue block14;
                    }
                    FieldValidatorSourceImpl.parseError(cursor, specification);
                }
                case VALUE_START: {
                    start = cursor;
                    state = State.VALUE_END;
                    break;
                }
                case VALUE_END: {
                    if (!Character.isWhitespace(ch) && ch != ',') break;
                    String value = specification.substring(start, cursor);
                    result.add(new ValidatorSpecification(type, value));
                    type = null;
                    skipWhitespace = true;
                    state = State.COMMA;
                    continue block14;
                }
                case COMMA: {
                    if (ch == ',') {
                        skipWhitespace = true;
                        state = State.TYPE_START;
                        break;
                    }
                    FieldValidatorSourceImpl.parseError(cursor, specification);
                }
            }
            ++cursor;
        }
        switch (state) {
            case TYPE_END: {
                type = specification.substring(start);
            }
            case EQUALS_OR_COMMA: {
                result.add(new ValidatorSpecification(type));
                break;
            }
            case VALUE_START: {
                result.add(new ValidatorSpecification(type, ""));
                break;
            }
            case VALUE_END: {
                result.add(new ValidatorSpecification(type, specification.substring(start)));
                break;
            }
        }
        return result;
    }

    private static void parseError(int cursor, String specification) {
        throw new RuntimeException(ServicesMessages.validatorSpecificationParseError(cursor, specification));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        TYPE_START,
        TYPE_END,
        EQUALS_OR_COMMA,
        VALUE_START,
        VALUE_END,
        COMMA;

    }
}

