/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.Stack;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.services.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentImpl
implements Environment,
ThreadCleanupListener {
    private Map<Class, LinkedList> typeToStack = CollectionFactory.newMap();
    private final Stack<Map<Class, LinkedList>> cloakStack = CollectionFactory.newStack();
    private final OneShotLock lock = new OneShotLock();

    private <T> LinkedList<T> stackFor(Class<T> type) {
        this.lock.check();
        LinkedList result = this.typeToStack.get(type);
        if (result == null) {
            result = CollectionFactory.newLinkedList();
            this.typeToStack.put(type, result);
        }
        return result;
    }

    @Override
    public <T> T peek(Class<T> type) {
        LinkedList<T> stack = this.stackFor(type);
        return stack.isEmpty() ? null : (T)stack.getFirst();
    }

    @Override
    public <T> T peekRequired(Class<T> type) {
        T result = this.peek(type);
        if (result == null) {
            List types = CollectionFactory.newList();
            for (Map.Entry<Class, LinkedList> e : this.typeToStack.entrySet()) {
                LinkedList list = e.getValue();
                if (list == null || list.isEmpty()) continue;
                types.add(e.getKey());
            }
            throw new UnknownValueException(String.format("No object of type %s is available from the Environment.", type.getName()), new AvailableValues("Environmentals", (Collection)F.flow(this.typeToStack.keySet()).map((Mapper)new Mapper<Class, String>(){

                public String map(Class element) {
                    return element.getName();
                }
            }).toList()));
        }
        return result;
    }

    @Override
    public <T> T pop(Class<T> type) {
        LinkedList<T> stack = this.stackFor(type);
        return stack.removeFirst();
    }

    @Override
    public <T> T push(Class<T> type, T instance) {
        LinkedList<T> stack = this.stackFor(type);
        T result = stack.isEmpty() ? null : (T)stack.getFirst();
        stack.addFirst(instance);
        return result;
    }

    @Override
    public void clear() {
        throw new IllegalStateException("Environment.clear() is no longer supported.");
    }

    public void threadDidCleanup() {
        this.lock.lock();
    }

    @Override
    public void cloak() {
        this.cloakStack.push(this.typeToStack);
        this.typeToStack = CollectionFactory.newMap();
    }

    @Override
    public void decloak() {
        this.typeToStack = (Map)this.cloakStack.pop();
    }
}

