/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.StylesheetLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentLinkerImpl
implements DocumentLinker {
    private final List<String> scripts = CollectionFactory.newList();
    private final Map<InitializationPriority, StringBuilder> priorityToScript = CollectionFactory.newMap();
    private final Map<InitializationPriority, JSONObject> priorityToInit = CollectionFactory.newMap();
    private final List<StylesheetLink> includedStylesheets = CollectionFactory.newList();
    private final boolean compactJSON;
    private final boolean omitGeneratorMetaTag;
    private final String tapestryBanner;
    private boolean hasDynamicScript;

    public DocumentLinkerImpl(boolean omitGeneratorMetaTag, String tapestryVersion, boolean compactJSON) {
        this.omitGeneratorMetaTag = omitGeneratorMetaTag;
        this.tapestryBanner = String.format("Apache Tapestry Framework (version %s)", tapestryVersion);
        this.compactJSON = compactJSON;
    }

    @Override
    public void addStylesheetLink(StylesheetLink sheet) {
        this.includedStylesheets.add(sheet);
    }

    @Override
    public void addScriptLink(String scriptURL) {
        this.scripts.add(scriptURL);
    }

    @Override
    public void addScript(InitializationPriority priority, String script) {
        StringBuilder builder = this.priorityToScript.get((Object)priority);
        if (builder == null) {
            builder = new StringBuilder();
            this.priorityToScript.put(priority, builder);
        }
        builder.append(script);
        builder.append("\n");
        this.hasDynamicScript = true;
    }

    @Override
    public void setInitialization(InitializationPriority priority, JSONObject initialization) {
        this.priorityToInit.put(priority, initialization);
        this.hasDynamicScript = true;
    }

    public void updateDocument(Document document) {
        Element root = document.getRootElement();
        if (root == null) {
            return;
        }
        this.addStylesheetsToHead(root, this.includedStylesheets);
        boolean isHtmlRoot = root.getName().equals("html");
        if (!this.omitGeneratorMetaTag && isHtmlRoot) {
            Element head = this.findOrCreateElement(root, "head", true);
            Element existingMeta = head.find("meta");
            DocumentLinkerImpl.addElementBefore(head, existingMeta, "meta", "name", "generator", "content", this.tapestryBanner);
        }
        this.addScriptElements(root);
    }

    private static Element addElementBefore(Element container, Element insertionPoint, String name, String ... namesAndValues) {
        if (insertionPoint == null) {
            return container.element(name, namesAndValues);
        }
        return insertionPoint.elementBefore(name, namesAndValues);
    }

    private void addScriptElements(Element root) {
        if (this.scripts.isEmpty() && !this.hasDynamicScript) {
            return;
        }
        String rootElementName = root.getName();
        if (!rootElementName.equals("html")) {
            throw new RuntimeException(ServicesMessages.documentMissingHTMLRoot(rootElementName));
        }
        Element head = this.findOrCreateElement(root, "head", true);
        this.addScriptLinksForIncludedScripts(head, this.scripts);
        if (this.hasDynamicScript) {
            this.addDynamicScriptBlock(this.findOrCreateElement(root, "body", false));
        }
    }

    private Element findOrCreateElement(Element root, String childElement, boolean atTop) {
        Element container = root.find(childElement);
        if (container == null) {
            container = atTop ? root.elementAt(0, childElement, new String[0]) : root.element(childElement, new String[0]);
        }
        return container;
    }

    protected void addDynamicScriptBlock(Element body) {
        StringBuilder block = new StringBuilder();
        boolean wrapped = false;
        for (InitializationPriority p : InitializationPriority.values()) {
            if (p != InitializationPriority.IMMEDIATE && !wrapped && (this.priorityToScript.containsKey((Object)p) || this.priorityToInit.containsKey((Object)p))) {
                block.append("Tapestry.onDOMLoaded(function() {\n");
                wrapped = true;
            }
            this.add(block, p);
        }
        if (wrapped) {
            block.append("});\n");
        }
        Element e = body.element("script", "type", "text/javascript");
        e.raw(block.toString());
    }

    private void add(StringBuilder block, InitializationPriority priority) {
        this.add(block, this.priorityToScript.get((Object)priority));
        this.add(block, this.priorityToInit.get((Object)priority));
    }

    private void add(StringBuilder block, JSONObject init) {
        if (init == null) {
            return;
        }
        block.append("Tapestry.init(");
        block.append(init.toString(this.compactJSON));
        block.append(");\n");
    }

    private void add(StringBuilder block, StringBuilder content) {
        if (content == null) {
            return;
        }
        block.append((CharSequence)content);
    }

    protected void addScriptLinksForIncludedScripts(Element headElement, List<String> scripts) {
        Element container = DocumentLinkerImpl.createTemporaryContainer(headElement, "script", "script-container");
        for (String script : scripts) {
            container.element("script", "type", "text/javascript", "src", script);
        }
        container.pop();
    }

    private static Element createTemporaryContainer(Element headElement, String existingElementName, String newElementName) {
        Element existingScript = headElement.find(existingElementName);
        return DocumentLinkerImpl.addElementBefore(headElement, existingScript, newElementName, new String[0]);
    }

    protected void addStylesheetsToHead(Element root, List<StylesheetLink> stylesheets) {
        int count = stylesheets.size();
        if (count == 0) {
            return;
        }
        String rootElementName = root.getName();
        if (!rootElementName.equals("html")) {
            return;
        }
        Element head = this.findOrCreateElement(root, "head", true);
        Element container = DocumentLinkerImpl.createTemporaryContainer(head, "style", "stylesheet-container");
        for (int i = 0; i < count; ++i) {
            stylesheets.get(i).add(container);
        }
        container.pop();
    }
}

