/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ExceptionReporter;
import org.apache.tapestry5.services.RequestExceptionHandler;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;

public class DefaultRequestExceptionHandler
implements RequestExceptionHandler {
    private final RequestPageCache pageCache;
    private final PageResponseRenderer renderer;
    private final Logger logger;
    private final String pageName;
    private final Response response;

    public DefaultRequestExceptionHandler(RequestPageCache pageCache, PageResponseRenderer renderer, Logger logger, @Symbol(value="tapestry.exception-report-page") String pageName, Response response) {
        this.pageCache = pageCache;
        this.renderer = renderer;
        this.logger = logger;
        this.pageName = pageName;
        this.response = response;
    }

    public void handleRequestException(Throwable exception) throws IOException {
        this.logger.error(ServicesMessages.requestException(exception), exception);
        this.response.setStatus(500);
        String rawMessage = InternalUtils.toMessage((Throwable)exception);
        String encoded = URLEncoder.encode(rawMessage, "UTF-8").replace("+", "%20");
        this.response.setHeader("X-Tapestry-ErrorMessage", encoded);
        Page page = this.pageCache.get(this.pageName);
        ExceptionReporter rootComponent = (ExceptionReporter)((Object)page.getRootComponent());
        rootComponent.reportException(exception);
        this.renderer.renderPageResponse(page);
    }
}

