/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.annotation.Annotation;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.InjectionProvider2;

public class DefaultInjectionProvider
implements InjectionProvider2 {
    private final MasterObjectProvider masterObjectProvider;
    private final ObjectLocator locator;
    private final ComponentClassCache classCache;

    public DefaultInjectionProvider(MasterObjectProvider masterObjectProvider, ObjectLocator locator, ComponentClassCache classCache) {
        this.masterObjectProvider = masterObjectProvider;
        this.locator = locator;
        this.classCache = classCache;
    }

    public boolean provideInjection(final PlasticField field, ObjectLocator locator, MutableComponentModel componentModel) {
        Class fieldType = this.classCache.forName(field.getTypeName());
        Object injectionValue = this.masterObjectProvider.provide(fieldType, new AnnotationProvider(){

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)field.getAnnotation(annotationClass);
            }
        }, this.locator, false);
        if (injectionValue != null) {
            field.inject(injectionValue);
            return true;
        }
        return false;
    }
}

