/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.RequestGlobals;

public class ComponentSourceImpl
implements ComponentSource {
    private final RequestPageCache pageCache;
    private final ComponentClassResolver resolver;
    private final RequestGlobals globals;

    public ComponentSourceImpl(RequestPageCache pageCache, ComponentClassResolver resolver, RequestGlobals globals) {
        this.pageCache = pageCache;
        this.resolver = resolver;
        this.globals = globals;
    }

    public Component getComponent(String completeId) {
        assert (InternalUtils.isNonBlank((String)completeId));
        int colonx = completeId.indexOf(58);
        if (colonx < 0) {
            Page page = this.pageCache.get(completeId);
            return page.getRootComponent();
        }
        String pageName = completeId.substring(0, colonx);
        Page page = this.pageCache.get(pageName);
        String nestedId = completeId.substring(colonx + 1);
        String mixinId = null;
        int dollarx = nestedId.indexOf("$");
        if (dollarx > 0) {
            mixinId = nestedId.substring(dollarx + 1);
            nestedId = nestedId.substring(0, dollarx);
        }
        ComponentPageElement element = page.getComponentElementByNestedId(nestedId);
        if (mixinId == null) {
            return element.getComponent();
        }
        ComponentResources resources = element.getMixinResources(mixinId);
        return resources.getComponent();
    }

    public Component getPage(String pageName) {
        assert (pageName != null);
        Page page = this.pageCache.get(pageName);
        return page.getRootComponent();
    }

    public Component getPage(Class pageClass) {
        assert (pageClass != null);
        String pageName = this.resolver.resolvePageClassNameToPageName(pageClass.getName());
        return this.getPage(pageName);
    }

    public Component getActivePage() {
        String pageName = this.globals.getActivePageName();
        return pageName == null ? null : this.getPage(pageName);
    }
}

