/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.services.ComponentEventResultProcessor;

public class ComponentResultProcessorWrapper
implements TrackableComponentEventCallback {
    private boolean aborted;
    private IOException exception;
    private final ComponentEventResultProcessor processor;

    public ComponentResultProcessorWrapper(ComponentEventResultProcessor processor) {
        this.processor = processor;
    }

    public boolean handleResult(Object result) {
        if (this.aborted) {
            throw new IllegalStateException("Event callback has already received and processed a result value and can not do so again.");
        }
        try {
            this.processor.processResultValue(result);
        }
        catch (IOException ex) {
            this.exception = ex;
        }
        this.aborted = true;
        return true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void rethrow() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

