/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.ComponentLayer;
import org.apache.tapestry5.services.InvalidationListener;

public class ComponentClassCacheImpl
implements ComponentClassCache,
InvalidationListener {
    private final Map<String, Class> cache = CollectionFactory.newConcurrentMap();
    private final PlasticProxyFactory plasticFactory;
    private final TypeCoercer typeCoercer;

    public ComponentClassCacheImpl(@ComponentLayer PlasticProxyFactory plasticFactory, TypeCoercer typeCoercer) {
        this.plasticFactory = plasticFactory;
        this.typeCoercer = typeCoercer;
    }

    public void objectWasInvalidated() {
        this.cache.clear();
    }

    public Object defaultValueForType(String className) {
        Class clazz = this.forName(className);
        if (!clazz.isPrimitive()) {
            return null;
        }
        return this.typeCoercer.coerce((Object)0, clazz);
    }

    public Class forName(String className) {
        Class result = this.cache.get(className);
        if (result == null) {
            result = this.lookupClassForType(className);
            this.cache.put(className, result);
        }
        return result;
    }

    private Class lookupClassForType(String className) {
        ClassLoader componentLoader = this.plasticFactory.getClassLoader();
        try {
            return PlasticInternalUtils.toClass((ClassLoader)componentLoader, (String)className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

