/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tapestry5.internal.services.SessionImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.SessionPersistedObjectAnalyzer;

public class ClusteredSessionImpl
extends SessionImpl {
    private final SessionPersistedObjectAnalyzer analyzer;
    private final Map<String, Object> sessionAttributeCache = CollectionFactory.newMap();

    public ClusteredSessionImpl(HttpServletRequest request, HttpSession session, SessionPersistedObjectAnalyzer analyzer) {
        super(request, session);
        this.analyzer = analyzer;
    }

    public Object getAttribute(String name) {
        Object result = super.getAttribute(name);
        this.sessionAttributeCache.put(name, result);
        return result;
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        this.sessionAttributeCache.put(name, value);
    }

    public void invalidate() {
        super.invalidate();
        this.sessionAttributeCache.clear();
    }

    public void restoreDirtyObjects() {
        if (this.isInvalidated()) {
            return;
        }
        if (this.sessionAttributeCache.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.sessionAttributeCache.entrySet()) {
            String attributeName = entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue == null || !this.analyzer.checkAndResetDirtyState(attributeValue)) continue;
            super.setAttribute(attributeName, attributeValue);
        }
    }
}

