/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.zip.GZIPInputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.ClientDataSinkImpl;
import org.apache.tapestry5.internal.util.Base64InputStream;
import org.apache.tapestry5.internal.util.MacOutputStream;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ClientDataEncoder;
import org.apache.tapestry5.services.ClientDataSink;
import org.apache.tapestry5.services.URLEncoder;
import org.slf4j.Logger;

public class ClientDataEncoderImpl
implements ClientDataEncoder {
    private final URLEncoder urlEncoder;
    private final Key hmacKey;

    public ClientDataEncoderImpl(URLEncoder urlEncoder, @Symbol(value="tapestry.hmac-passphrase") String passphrase, Logger logger, @Symbol(value="tapestry.app-package") String applicationPackageName, AlertManager alertManager) throws UnsupportedEncodingException {
        this.urlEncoder = urlEncoder;
        if (passphrase.equals("")) {
            String message = String.format("The symbol '%s' has not been configured. This is used to configure hash-based message authentication of Tapestry data stored in forms, or in the URL. You application is less secure, and more vulnerable to denial-of-service attacks, when this symbol is not configured.", "tapestry.hmac-passphrase");
            alertManager.error(message);
            logger.error(message);
            passphrase = applicationPackageName;
        }
        this.hmacKey = new SecretKeySpec(passphrase.getBytes("UTF8"), "HmacSHA1");
    }

    public ClientDataSink createSink() {
        try {
            return new ClientDataSinkImpl(this.urlEncoder, this.hmacKey);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ObjectInputStream decodeClientData(String clientData) {
        int colonx = clientData.indexOf(58);
        if (colonx < 0) {
            throw new IllegalArgumentException("Client data must be prefixed with its HMAC code.");
        }
        String storedHmacResult = clientData.substring(0, colonx);
        String clientStream = clientData.substring(colonx + 1);
        try {
            Base64InputStream b64in = new Base64InputStream(clientStream);
            this.validateHMAC(storedHmacResult, b64in);
            b64in.reset();
            BufferedInputStream buffered = new BufferedInputStream(new GZIPInputStream(b64in));
            return new ObjectInputStream(buffered);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void validateHMAC(String storedHmacResult, Base64InputStream b64in) throws IOException {
        MacOutputStream macOs = MacOutputStream.streamFor(this.hmacKey);
        TapestryInternalUtils.copy(b64in, macOs);
        macOs.close();
        String actual = macOs.getResult();
        if (!storedHmacResult.equals(actual)) {
            throw new IOException("Client data associated with the current request appears to have been tampered with (the HMAC signature does not match).");
        }
    }

    public ObjectInputStream decodeEncodedClientData(String clientData) throws IOException {
        return this.decodeClientData(this.urlEncoder.decode(clientData));
    }
}

