/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.internal.services.AbstractAsset;
import org.apache.tapestry5.internal.services.ResourceDigestManager;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.internal.util.ClasspathResource;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.AssetPathConverter;
import org.apache.tapestry5.services.ClasspathAssetAliasManager;
import org.apache.tapestry5.services.ClasspathProvider;

@Marker(value={ClasspathProvider.class})
public class ClasspathAssetFactory
implements AssetFactory {
    private final ResourceDigestManager digestManager;
    private final ClasspathAssetAliasManager aliasManager;
    private final ClasspathResource rootResource;
    private final AssetPathConverter converter;
    private final boolean invariant;

    public ClasspathAssetFactory(ResourceDigestManager digestManager, ClasspathAssetAliasManager aliasManager, AssetPathConverter converter) {
        this.digestManager = digestManager;
        this.aliasManager = aliasManager;
        this.converter = converter;
        this.rootResource = new ClasspathResource("");
        this.invariant = converter.isInvariant();
    }

    private String clientURL(Resource resource) {
        String defaultPath = this.buildDefaultPath(resource);
        return this.converter.convertAssetPath(defaultPath);
    }

    private String buildDefaultPath(Resource resource) {
        boolean requiresDigest = this.digestManager.requiresDigest(resource);
        String path = resource.getPath();
        if (requiresDigest) {
            int lastdotx = path.lastIndexOf(46);
            path = path.substring(0, lastdotx + 1) + this.digestManager.getDigest(resource) + path.substring(lastdotx);
        }
        return this.aliasManager.toClientURL(path);
    }

    public Asset createAsset(Resource resource) {
        if (this.invariant) {
            return this.createInvariantAsset(resource);
        }
        return this.createVariantAsset(resource);
    }

    private Asset createVariantAsset(final Resource resource) {
        return new AbstractAsset(false){

            public Resource getResource() {
                return resource;
            }

            public String toClientURL() {
                return ClasspathAssetFactory.this.clientURL(resource);
            }
        };
    }

    private Asset createInvariantAsset(final Resource resource) {
        return new AbstractAsset(true){
            private String clientURL;

            public Resource getResource() {
                return resource;
            }

            public String toClientURL() {
                if (this.clientURL == null) {
                    this.clientURL = ClasspathAssetFactory.this.clientURL(resource);
                }
                return this.clientURL;
            }
        };
    }

    public Resource getRootResource() {
        return this.rootResource;
    }
}

