/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.ref.SoftReference;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.util.StrategyRegistry;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.AssetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetSourceImpl
implements AssetSource {
    private final StrategyRegistry<AssetFactory> registry;
    private final ThreadLocale threadLocale;
    private final Map<String, Resource> prefixToRootResource = CollectionFactory.newMap();
    private final Map<Resource, SoftReference<Asset>> cache = CollectionFactory.newWeakHashMap();
    private final SymbolSource symbolSource;

    public AssetSourceImpl(ThreadLocale threadLocale, Map<String, AssetFactory> configuration, SymbolSource symbolSource) {
        this.threadLocale = threadLocale;
        this.symbolSource = symbolSource;
        Map byResourceClass = CollectionFactory.newMap();
        for (Map.Entry<String, AssetFactory> e : configuration.entrySet()) {
            String prefix = e.getKey();
            AssetFactory factory = e.getValue();
            Resource rootResource = factory.getRootResource();
            byResourceClass.put(rootResource.getClass(), factory);
            this.prefixToRootResource.put(prefix, rootResource);
        }
        this.registry = StrategyRegistry.newInstance(AssetFactory.class, (Map)byResourceClass);
    }

    @Override
    public Asset getClasspathAsset(String path) {
        return this.getClasspathAsset(path, null);
    }

    @Override
    public Asset getClasspathAsset(String path, Locale locale) {
        return this.getAsset(null, path, locale);
    }

    @Override
    public Asset getContextAsset(String path, Locale locale) {
        return this.getAsset(this.prefixToRootResource.get("context"), path, locale);
    }

    @Override
    public Asset getAsset(Resource baseResource, String path, Locale locale) {
        return this.getAssetInLocale(baseResource, path, this.defaulted(locale));
    }

    @Override
    public Resource resourceForPath(String path) {
        return this.getUnlocalizedResource(null, path);
    }

    @Override
    public Asset getExpandedAsset(String path) {
        return this.getUnlocalizedAsset(this.symbolSource.expandSymbols(path));
    }

    @Override
    public Asset getUnlocalizedAsset(String path) {
        return this.getAssetInLocale(null, path, null);
    }

    private Asset getAssetInLocale(Resource baseResource, String path, Locale locale) {
        return this.getLocalizedAssetFromResource(this.getUnlocalizedResource(baseResource, path), locale);
    }

    private Resource getUnlocalizedResource(Resource baseResource, String path) {
        assert (InternalUtils.isNonBlank((String)path));
        int colonx = path.indexOf(58);
        if (colonx < 0) {
            Resource root = baseResource != null ? baseResource : this.prefixToRootResource.get("classpath");
            return root.forFile(path);
        }
        String prefix = path.substring(0, colonx);
        Resource root = this.prefixToRootResource.get(prefix);
        if (root == null) {
            throw new IllegalArgumentException(ServicesMessages.unknownAssetPrefix(path));
        }
        return root.forFile(path.substring(colonx + 1));
    }

    private Asset getLocalizedAssetFromResource(Resource unlocalized, Locale locale) {
        Resource localized;
        Resource resource = localized = locale == null ? unlocalized : unlocalized.forLocale(locale);
        if (localized == null || !localized.exists()) {
            throw new RuntimeException(ServicesMessages.assetDoesNotExist(unlocalized));
        }
        return this.getAssetForResource(localized);
    }

    private synchronized Asset getAssetForResource(Resource resource) {
        Asset result = TapestryInternalUtils.getAndDeref(this.cache, resource);
        if (result == null) {
            result = this.createAssetFromResource(resource);
            this.cache.put(resource, new SoftReference<Asset>(result));
        }
        return result;
    }

    private Locale defaulted(Locale locale) {
        return locale != null ? locale : this.threadLocale.getLocale();
    }

    private Asset createAssetFromResource(Resource resource) {
        Class<?> resourceClass = resource.getClass();
        AssetFactory factory = (AssetFactory)this.registry.get(resourceClass);
        return factory.createAsset(resource);
    }
}

