/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.annotations.UsesMappedConfiguration;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.assets.AssetRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsesMappedConfiguration(value=AssetRequestHandler.class)
public class AssetDispatcher
implements Dispatcher {
    private final Map<String, AssetRequestHandler> pathToHandler = CollectionFactory.newMap();
    private final List<String> assetPaths = CollectionFactory.newList();
    private final String pathPrefix;

    public AssetDispatcher(Map<String, AssetRequestHandler> configuration, @Symbol(value="tapestry.application-version") String applicationVersion, @Symbol(value="tapestry.application-folder") String applicationFolder, @Symbol(value="tapestry.asset-path-prefix") String assetPathPrefix) {
        String folder = applicationFolder.equals("") ? "" : "/" + applicationFolder;
        this.pathPrefix = folder + assetPathPrefix + applicationVersion + "/";
        for (String path : configuration.keySet()) {
            String extendedPath = this.pathPrefix + path + "/";
            this.pathToHandler.put(extendedPath, configuration.get(path));
            this.assetPaths.add(extendedPath);
        }
        Collections.sort(this.assetPaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
    }

    @Override
    public boolean dispatch(Request request, Response response) throws IOException {
        String path = request.getPath();
        if (!path.startsWith(this.pathPrefix)) {
            return false;
        }
        for (String extendedPath : this.assetPaths) {
            String extraPath;
            AssetRequestHandler handler;
            boolean handled;
            if (!path.startsWith(extendedPath) || !(handled = (handler = this.pathToHandler.get(extendedPath)).handleAssetRequest(request, response, extraPath = path.substring(extendedPath.length())))) continue;
            return true;
        }
        response.sendError(404, path);
        return true;
    }
}

