/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.internal.services.AjaxPartialResponseRenderer;
import org.apache.tapestry5.internal.services.ComponentResultProcessorWrapper;
import org.apache.tapestry5.internal.services.PageActivator;
import org.apache.tapestry5.internal.services.PageContentTypeAnalyzer;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Ajax;
import org.apache.tapestry5.services.ComponentEventRequestHandler;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.Request;

public class AjaxComponentEventRequestHandler
implements ComponentEventRequestHandler {
    private final RequestPageCache cache;
    private final Request request;
    private final PageRenderQueue queue;
    private final ComponentEventResultProcessor resultProcessor;
    private final PageContentTypeAnalyzer pageContentTypeAnalyzer;
    private final Environment environment;
    private final AjaxPartialResponseRenderer partialRenderer;
    private final PageActivator pageActivator;

    public AjaxComponentEventRequestHandler(RequestPageCache cache, Request request, PageRenderQueue queue, @Ajax ComponentEventResultProcessor resultProcessor, PageActivator pageActivator, PageContentTypeAnalyzer pageContentTypeAnalyzer, Environment environment, AjaxPartialResponseRenderer partialRenderer) {
        this.cache = cache;
        this.queue = queue;
        this.resultProcessor = resultProcessor;
        this.pageActivator = pageActivator;
        this.pageContentTypeAnalyzer = pageContentTypeAnalyzer;
        this.request = request;
        this.environment = environment;
        this.partialRenderer = partialRenderer;
    }

    public void handle(ComponentEventRequestParameters parameters) throws IOException {
        Page activePage = this.cache.get(parameters.getActivePageName());
        final Holder<Boolean> resultProcessorInvoked = Holder.create();
        resultProcessorInvoked.put(false);
        ComponentEventResultProcessor interceptor = new ComponentEventResultProcessor(){

            public void processResultValue(Object value) throws IOException {
                resultProcessorInvoked.put(true);
                AjaxComponentEventRequestHandler.this.resultProcessor.processResultValue(value);
            }
        };
        this.queue.setRenderingPage(activePage);
        if (this.pageActivator.activatePage(activePage.getRootElement().getComponentResources(), parameters.getPageActivationContext(), interceptor)) {
            return;
        }
        ContentType contentType = this.pageContentTypeAnalyzer.findContentType(activePage);
        this.request.setAttribute("content-type", contentType);
        Page containerPage = this.cache.get(parameters.getContainingPageName());
        ComponentPageElement element = containerPage.getComponentElementByNestedId(parameters.getNestedComponentId());
        ComponentResultProcessorWrapper callback = new ComponentResultProcessorWrapper(interceptor);
        this.environment.push(ComponentEventResultProcessor.class, interceptor);
        this.environment.push(TrackableComponentEventCallback.class, callback);
        boolean handled = element.triggerContextEvent(parameters.getEventType(), parameters.getEventContext(), callback);
        if (!handled) {
            throw new TapestryException(ServicesMessages.eventNotHandled(element, parameters.getEventType()), (Object)element, null);
        }
        this.environment.pop(TrackableComponentEventCallback.class);
        this.environment.pop(ComponentEventResultProcessor.class);
        boolean wasInvoked = (Boolean)resultProcessorInvoked.get();
        if (!wasInvoked && this.queue.isPartialRenderInitialized()) {
            this.partialRenderer.renderPartialPageMarkup();
            return;
        }
        if (wasInvoked) {
            return;
        }
        JSONObject reply = new JSONObject();
        this.resultProcessor.processResultValue(reply);
    }
}

