/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.dom;

import java.util.Map;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.dom.MarkupModel;
import org.apache.tapestry5.internal.TapestryInternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    private final Element element;
    private final String namespace;
    private final String name;
    String value;
    Attribute nextAttribute;

    Attribute(Element element, String namespace, String name, String value, Attribute nextAttribute) {
        this.element = element;
        this.namespace = namespace;
        this.name = name;
        this.value = value;
        this.nextAttribute = nextAttribute;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    void render(MarkupModel model, StringBuilder builder, Map<String, String> namespaceURIToPrefix) {
        builder.append(" ");
        builder.append(this.element.toPrefixedName(namespaceURIToPrefix, this.namespace, this.name));
        builder.append("=");
        builder.append(model.getAttributeQuote());
        model.encodeQuoted(this.value, builder);
        builder.append(model.getAttributeQuote());
    }

    boolean matches(String namespace, String name) {
        return TapestryInternalUtils.isEqual(this.namespace, namespace) && this.name.equalsIgnoreCase(name);
    }
}

