/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.dom;

import org.apache.tapestry5.dom.MarkupModel;

public abstract class AbstractMarkupModel
implements MarkupModel {
    private final boolean useApostropheForAttributes;

    protected AbstractMarkupModel(boolean useApostropheForAttributes) {
        this.useApostropheForAttributes = useApostropheForAttributes;
    }

    public char getAttributeQuote() {
        return this.useApostropheForAttributes ? (char)'\'' : '\"';
    }

    public String encode(String content) {
        int length = content.length();
        StringBuilder builder = null;
        block5: for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            switch (ch) {
                case '<': {
                    if (builder == null) {
                        builder = new StringBuilder(2 * length);
                        builder.append(content.substring(0, i));
                    }
                    builder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    if (builder == null) {
                        builder = new StringBuilder(2 * length);
                        builder.append(content.substring(0, i));
                    }
                    builder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    if (builder == null) {
                        builder = new StringBuilder(2 * length);
                        builder.append(content.substring(0, i));
                    }
                    builder.append("&amp;");
                    continue block5;
                }
                default: {
                    if (builder == null) continue block5;
                    builder.append(ch);
                }
            }
        }
        return builder == null ? content : builder.toString();
    }

    public void encodeQuoted(String content, StringBuilder builder) {
        assert (content != null);
        int length = content.length();
        block7: for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            switch (ch) {
                case '<': {
                    builder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    if (!this.useApostropheForAttributes) {
                        builder.append("&quot;");
                        continue block7;
                    }
                    builder.append(ch);
                    continue block7;
                }
                case '\'': {
                    if (this.useApostropheForAttributes) {
                        builder.append("&#39;");
                        continue block7;
                    }
                }
                default: {
                    builder.append(ch);
                }
            }
        }
    }
}

