/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.pages;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tapestry5.annotations.ContentType;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ExceptionReporter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ContentType(value="text/html")
public class ExceptionReport
implements ExceptionReporter {
    private static final String PATH_SEPARATOR_PROPERTY = "path.separator";
    private static final Pattern PATH_RECOGNIZER = Pattern.compile("\\..*path$");
    @Property
    private String attributeName;
    @Inject
    @Property
    private Request request;
    @Inject
    @Symbol(value="tapestry.production-mode")
    @Property(write=false)
    private boolean productionMode;
    @Inject
    @Symbol(value="tapestry.version")
    @Property(write=false)
    private String tapestryVersion;
    @Inject
    @Symbol(value="tapestry.application-version")
    @Property(write=false)
    private String applicationVersion;
    @Property(write=false)
    private Throwable rootException;
    @Property
    private String propertyName;
    private final String pathSeparator = System.getProperty("path.separator");

    @Override
    public void reportException(Throwable exception) {
        this.rootException = exception;
    }

    public boolean getHasSession() {
        return this.request.getSession(false) != null;
    }

    public Session getSession() {
        return this.request.getSession(false);
    }

    public Object getAttributeValue() {
        return this.getSession().getAttribute(this.attributeName);
    }

    public List<String> getSystemProperties() {
        return InternalUtils.sortedKeys((Map)System.getProperties());
    }

    public String getPropertyValue() {
        return System.getProperty(this.propertyName);
    }

    public boolean isComplexProperty() {
        return PATH_RECOGNIZER.matcher(this.propertyName).find() && this.getPropertyValue().contains(this.pathSeparator);
    }

    public String[] getComplexPropertyValue() {
        return this.getPropertyValue().split(this.pathSeparator);
    }
}

